/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedReluX<U>
extends PrimitiveOp {
    private Output<U> activations;
    private Output<Float> minActivations;
    private Output<Float> maxActivations;

    public static <U, T> QuantizedReluX<U> create(Scope scope, Operand<T> features, Operand<Float> maxValue, Operand<Float> minFeatures, Operand<Float> maxFeatures, Class<U> outType) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedReluX", scope.makeOpName("QuantizedReluX"));
        opBuilder.addInput(features.asOutput());
        opBuilder.addInput(maxValue.asOutput());
        opBuilder.addInput(minFeatures.asOutput());
        opBuilder.addInput(maxFeatures.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("out_type", DataType.fromClass(outType));
        return new QuantizedReluX<U>(opBuilder.build());
    }

    public Output<U> activations() {
        return this.activations;
    }

    public Output<Float> minActivations() {
        return this.minActivations;
    }

    public Output<Float> maxActivations() {
        return this.maxActivations;
    }

    private QuantizedReluX(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.activations = operation.output(outputIdx++);
        this.minActivations = operation.output(outputIdx++);
        this.maxActivations = operation.output(outputIdx++);
    }
}

