/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse;

import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.IntNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.IntSparseSlice;
import org.tensorflow.ndarray.index.Index;

public class IntSparseNdArray
extends AbstractSparseNdArray<Integer, IntNdArray>
implements IntNdArray {
    protected IntSparseNdArray(LongNdArray indices, IntNdArray values, int defaultValue, DimensionalSpace dimensions) {
        super(indices, values, defaultValue, dimensions);
    }

    IntSparseNdArray(LongNdArray indices, IntNdArray values, DimensionalSpace dimensions) {
        this(indices, values, 0, dimensions);
    }

    IntSparseNdArray(IntDataBuffer dataBuffer, DimensionalSpace dimensions) {
        this(dataBuffer, 0, dimensions);
    }

    IntSparseNdArray(IntDataBuffer dataBuffer, int defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
        this.write(dataBuffer);
    }

    IntSparseNdArray(DimensionalSpace dimensions) {
        this(0, dimensions);
    }

    IntSparseNdArray(int defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
    }

    public static IntSparseNdArray create(LongNdArray indices, IntNdArray values, DimensionalSpace dimensions) {
        return new IntSparseNdArray(indices, values, dimensions);
    }

    public static IntSparseNdArray create(LongNdArray indices, IntNdArray values, int defaultValue, DimensionalSpace dimensions) {
        return new IntSparseNdArray(indices, values, defaultValue, dimensions);
    }

    public static IntSparseNdArray create(IntDataBuffer dataBuffer, DimensionalSpace dimensions) {
        return new IntSparseNdArray(dataBuffer, dimensions);
    }

    public static IntSparseNdArray create(IntDataBuffer dataBuffer, int defaultValue, DimensionalSpace dimensions) {
        return new IntSparseNdArray(dataBuffer, defaultValue, dimensions);
    }

    public static IntSparseNdArray create(DimensionalSpace dimensions) {
        return new IntSparseNdArray(dimensions);
    }

    public static IntSparseNdArray create(int defaultValue, DimensionalSpace dimensions) {
        return new IntSparseNdArray(defaultValue, dimensions);
    }

    public static IntSparseNdArray create(Shape shape) {
        return new IntSparseNdArray(DimensionalSpace.create(shape));
    }

    public static IntSparseNdArray create(int defaultValue, Shape shape) {
        return new IntSparseNdArray(defaultValue, DimensionalSpace.create(shape));
    }

    public static IntSparseNdArray create(IntDataBuffer buffer, Shape shape) {
        return new IntSparseNdArray(buffer, DimensionalSpace.create(shape));
    }

    public static IntSparseNdArray create(IntDataBuffer buffer, int defaultValue, Shape shape) {
        return new IntSparseNdArray(buffer, defaultValue, DimensionalSpace.create(shape));
    }

    public static IntSparseNdArray create(IntNdArray src) {
        IntDataBuffer buffer = DataBuffers.ofInts(src.size());
        src.read(buffer);
        return new IntSparseNdArray(buffer, DimensionalSpace.create(src.shape()));
    }

    public static IntSparseNdArray create(IntNdArray src, int defaultValue) {
        IntDataBuffer buffer = DataBuffers.ofInts(src.size());
        src.read(buffer);
        return new IntSparseNdArray(buffer, defaultValue, DimensionalSpace.create(src.shape()));
    }

    @Override
    public IntNdArray createValues(Shape shape) {
        return NdArrays.ofInts(shape);
    }

    @Override
    public IntNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new IntSparseSlice(this, position, sliceDimensions);
    }

    @Override
    public int getInt(long ... coordinates) {
        return (Integer)this.getObject(coordinates);
    }

    @Override
    public IntNdArray setInt(int value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntNdArray read(DataBuffer<Integer> dst) {
        return this.read((IntDataBuffer)dst);
    }

    @Override
    public IntNdArray read(IntDataBuffer dst) {
        Object[] defaults = new Integer[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write(defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            int value = ((IntNdArray)this.getValues()).getInt(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public IntNdArray write(IntDataBuffer src) {
        ArrayList<long[]> indices = new ArrayList<long[]>();
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (long i = 0L; i < src.size(); ++i) {
            if (src.getObject(i).equals(this.getDefaultValue())) continue;
            indices.add(this.toCoordinates(this.dimensions, i));
            values.add(src.getObject(i));
        }
        long[][] indicesArray = new long[indices.size()][];
        int[] valuesArray = new int[values.size()];
        for (int i = 0; i < indices.size(); ++i) {
            indicesArray[i] = (long[])indices.get(i);
            valuesArray[i] = (Integer)values.get(i);
        }
        this.setIndices(StdArrays.ndCopyOf(indicesArray));
        this.setValues(NdArrays.vectorOf(valuesArray));
        return this;
    }

    @Override
    public IntNdArray write(DataBuffer<Integer> src) {
        return this.write((IntDataBuffer)src);
    }

    @Override
    public IntNdArray toDense() {
        IntDataBuffer dataBuffer = DataBuffers.ofInts(this.shape().size());
        this.read(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    public IntNdArray fromDense(IntNdArray src) {
        IntDataBuffer buffer = DataBuffers.ofInts(src.size());
        src.read(buffer);
        this.write(buffer);
        return this;
    }

    @Override
    public IntNdArray slice(Index ... indices) {
        return (IntNdArray)super.slice(indices);
    }

    @Override
    public IntNdArray get(long ... coordinates) {
        return (IntNdArray)super.get(coordinates);
    }

    @Override
    public IntNdArray setObject(Integer value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntNdArray set(NdArray<Integer> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntNdArray copyTo(NdArray<Integer> dst) {
        return (IntNdArray)super.copyTo(dst);
    }

    @Override
    public IntNdArray createDefaultArray() {
        return NdArrays.scalarOf((Integer)this.getDefaultValue());
    }
}

