/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.web3j.abi.DefaultFunctionEncoder;
import org.web3j.abi.TypeDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.spi.FunctionEncoderProvider;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

public abstract class FunctionEncoder {
    private static FunctionEncoder DEFAULT_ENCODER;
    private static final ServiceLoader<FunctionEncoderProvider> loader;

    public static String encode(Function function) {
        return FunctionEncoder.encoder().encodeFunction(function);
    }

    public static String encodeConstructor(List<Type> parameters) {
        return FunctionEncoder.encoder().encodeParameters(parameters);
    }

    public static Function makeFunction(String fnname, List<String> solidityInputTypes, List<Object> arguments, List<String> solidityOutputTypes) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Type> encodedInput = new ArrayList<Type>();
        Iterator<Object> argit = arguments.iterator();
        for (String st : solidityInputTypes) {
            encodedInput.add(TypeDecoder.instantiateType(st, argit.next()));
        }
        ArrayList encodedOutput = new ArrayList();
        for (String st : solidityOutputTypes) {
            encodedOutput.add(TypeReference.makeTypeReference(st));
        }
        return new Function(fnname, encodedInput, encodedOutput);
    }

    protected abstract String encodeFunction(Function var1);

    protected abstract String encodeParameters(List<Type> var1);

    protected static String buildMethodSignature(String methodName, List<Type> parameters) {
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append("(");
        String params = parameters.stream().map(Type::getTypeAsString).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString();
    }

    protected static String buildMethodId(String methodSignature) {
        byte[] input = methodSignature.getBytes();
        byte[] hash = Hash.sha3((byte[])input);
        return Numeric.toHexString((byte[])hash).substring(0, 10);
    }

    private static FunctionEncoder encoder() {
        Iterator<FunctionEncoderProvider> iterator = loader.iterator();
        return iterator.hasNext() ? (FunctionEncoder)iterator.next().get() : FunctionEncoder.defaultEncoder();
    }

    private static FunctionEncoder defaultEncoder() {
        if (DEFAULT_ENCODER == null) {
            DEFAULT_ENCODER = new DefaultFunctionEncoder();
        }
        return DEFAULT_ENCODER;
    }

    static {
        loader = ServiceLoader.load(FunctionEncoderProvider.class);
    }
}

