/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen.kotlin;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeSpec;
import java.io.File;
import java.lang.reflect.Type;
import org.web3j.codegen.unit.gen.MethodFilter;
import org.web3j.codegen.unit.gen.UnitClassGenerator;
import org.web3j.codegen.unit.gen.utils.NameUtils;
import org.web3j.commons.JavaVersion;

public class KotlinClassGenerator
implements UnitClassGenerator {
    private final Class theContract;
    private final String packageName;
    private final String writePath;

    public KotlinClassGenerator(Class theContract, String packageName, String writePath) {
        this.theContract = theContract;
        this.packageName = packageName;
        this.writePath = writePath;
    }

    @Override
    public void writeClass() throws Exception {
        ClassName EVM_ANNOTATION = new ClassName("org.web3j", new String[]{"EVMTest"});
        AnnotationSpec.Builder annotationSpec = AnnotationSpec.builder((ClassName)EVM_ANNOTATION);
        if (JavaVersion.getJavaVersionAsDouble() < 11.0) {
            ClassName gethContainer = new ClassName("org.web3j", new String[]{"NodeType"});
            annotationSpec.addMember("%T.GETH", new Object[]{gethContainer});
        }
        ClassName TEST_INSTANCE_ANNOTATION = new ClassName("org.junit.jupiter.api", new String[]{"TestInstance"});
        AnnotationSpec.Builder testAnnotationSpec = AnnotationSpec.builder((ClassName)TEST_INSTANCE_ANNOTATION);
        ClassName lifeCycle = new ClassName("", new String[]{"TestInstance"});
        testAnnotationSpec.addMember("%T.Lifecycle.PER_CLASS", new Object[]{lifeCycle});
        PropertySpec contractInit = PropertySpec.builder((String)NameUtils.toCamelCase(this.theContract), (Type)this.theContract, (KModifier[])new KModifier[0]).addModifiers(new KModifier[]{KModifier.LATEINIT, KModifier.PRIVATE}).mutable(true).build();
        TypeSpec testClass = TypeSpec.classBuilder((String)(this.theContract.getSimpleName() + "Test")).addFunctions(MethodFilter.generateFunctionSpecsForEachTest(this.theContract)).addAnnotation(annotationSpec.build()).addAnnotation(testAnnotationSpec.build()).addProperty(contractInit).build();
        FileSpec kotlinFile = FileSpec.builder((String)this.packageName, (String)(this.theContract.getSimpleName() + "Test")).addType(testClass).build();
        kotlinFile.writeTo(new File(this.writePath));
    }
}

