/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Bytes;
import org.web3j.utils.Numeric;

public class LegacyTransaction
implements ITransaction {
    private TransactionType type;
    private BigInteger nonce;
    private BigInteger gasPrice;
    private BigInteger gasLimit;
    private String to;
    private BigInteger value;
    private String data;

    public LegacyTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        this(TransactionType.LEGACY, nonce, gasPrice, gasLimit, to, value, data);
    }

    @Deprecated
    public LegacyTransaction(TransactionType type, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        this.type = type;
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.to = to;
        this.value = value;
        this.data = data != null ? Numeric.cleanHexPrefix((String)data) : null;
    }

    @Override
    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((BigInteger)this.getNonce()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasPrice()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        String to = this.getTo();
        if (to != null && to.length() > 0) {
            result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)to)));
        } else {
            result.add((RlpType)RlpString.create((String)""));
        }
        result.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)this.getData());
        result.add((RlpType)RlpString.create((byte[])data));
        if (signatureData != null) {
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getV())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getR())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getS())));
        }
        return result;
    }

    public static LegacyTransaction createContractTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String init) {
        return new LegacyTransaction(nonce, gasPrice, gasLimit, "", value, init);
    }

    public static LegacyTransaction createEtherTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value) {
        return new LegacyTransaction(nonce, gasPrice, gasLimit, to, value, "");
    }

    public static LegacyTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data) {
        return LegacyTransaction.createTransaction(nonce, gasPrice, gasLimit, to, BigInteger.ZERO, data);
    }

    public static LegacyTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        return new LegacyTransaction(nonce, gasPrice, gasLimit, to, value, data);
    }

    @Override
    public BigInteger getNonce() {
        return this.nonce;
    }

    @Override
    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    @Override
    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    @Override
    public String getTo() {
        return this.to;
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public TransactionType getType() {
        return this.type;
    }
}

