/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityFilterAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.SecurityFilterChain;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.BodyFilters;
import org.zalando.logbook.ChunkingHttpLogWriter;
import org.zalando.logbook.Conditions;
import org.zalando.logbook.CurlHttpLogFormatter;
import org.zalando.logbook.DefaultHttpLogFormatter;
import org.zalando.logbook.DefaultHttpLogWriter;
import org.zalando.logbook.HeaderFilter;
import org.zalando.logbook.HeaderFilters;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpLogWriter;
import org.zalando.logbook.JsonHttpLogFormatter;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.QueryFilters;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawRequestFilter;
import org.zalando.logbook.RawRequestFilters;
import org.zalando.logbook.RawResponseFilter;
import org.zalando.logbook.RawResponseFilters;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.ResponseFilter;
import org.zalando.logbook.httpclient.LogbookHttpRequestInterceptor;
import org.zalando.logbook.httpclient.LogbookHttpResponseInterceptor;
import org.zalando.logbook.servlet.LogbookFilter;
import org.zalando.logbook.servlet.Strategy;
import org.zalando.logbook.spring.LogbookProperties;

@Configuration
@ConditionalOnClass(value={Logbook.class})
@EnableConfigurationProperties(value={LogbookProperties.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class, WebMvcAutoConfiguration.class})
public class LogbookAutoConfiguration {
    private final LogbookProperties properties;

    @Autowired
    public LogbookAutoConfiguration(LogbookProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={Logbook.class})
    public Logbook logbook(Predicate<RawHttpRequest> condition, List<RawRequestFilter> rawRequestFilters, List<RawResponseFilter> rawResponseFilters, List<HeaderFilter> headerFilters, List<QueryFilter> queryFilters, List<BodyFilter> bodyFilters, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, HttpLogFormatter formatter, HttpLogWriter writer) {
        return Logbook.builder().condition(this.mergeWithExcludes(condition)).rawRequestFilters(rawRequestFilters).rawResponseFilters(rawResponseFilters).headerFilters(headerFilters).queryFilters(queryFilters).bodyFilters(bodyFilters).requestFilters(requestFilters).responseFilters(responseFilters).formatter(formatter).writer(writer).build();
    }

    private Predicate<RawHttpRequest> mergeWithExcludes(Predicate<RawHttpRequest> predicate) {
        return this.properties.getExclude().stream().map(Conditions::requestTo).map(Predicate::negate).reduce(predicate, Predicate::and);
    }

    @Bean
    @ConditionalOnMissingBean(name={"requestCondition"})
    public Predicate<RawHttpRequest> requestCondition() {
        return $ -> true;
    }

    @Bean
    @ConditionalOnMissingBean(value={RawRequestFilter.class})
    public RawRequestFilter rawRequestFilter() {
        return RawRequestFilters.defaultValue();
    }

    @Bean
    @ConditionalOnMissingBean(value={RawResponseFilter.class})
    public RawResponseFilter rawResponseFilter() {
        return RawResponseFilters.defaultValue();
    }

    @Bean
    @ConditionalOnMissingBean(value={QueryFilter.class})
    public QueryFilter queryFilter() {
        List<String> parameters = this.properties.getObfuscate().getParameters();
        return parameters.isEmpty() ? QueryFilters.defaultValue() : parameters.stream().map(parameter -> QueryFilters.replaceQuery((String)parameter, (String)"XXX")).collect(Collectors.toList()).stream().reduce(QueryFilter::merge).orElseGet(QueryFilter::none);
    }

    @Bean
    @ConditionalOnMissingBean(value={HeaderFilter.class})
    public HeaderFilter headerFilter() {
        List<String> headers = this.properties.getObfuscate().getHeaders();
        return headers.isEmpty() ? HeaderFilters.defaultValue() : headers.stream().map(header -> HeaderFilters.replaceHeaders(header::equalsIgnoreCase, (String)"XXX")).collect(Collectors.toList()).stream().reduce(HeaderFilter::merge).orElseGet(HeaderFilter::none);
    }

    @Bean
    @ConditionalOnMissingBean(value={BodyFilter.class})
    public BodyFilter bodyFilter() {
        return BodyFilters.defaultValue();
    }

    @Bean
    @ConditionalOnMissingBean(value={RequestFilter.class})
    public RequestFilter requestFilter() {
        return RequestFilter.none();
    }

    @Bean
    @ConditionalOnMissingBean(value={ResponseFilter.class})
    public ResponseFilter responseFilter() {
        return ResponseFilter.none();
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpLogFormatter.class})
    @ConditionalOnProperty(name={"logbook.format.style"}, havingValue="http")
    public HttpLogFormatter httpFormatter() {
        return new DefaultHttpLogFormatter();
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpLogFormatter.class})
    @ConditionalOnProperty(name={"logbook.format.style"}, havingValue="curl")
    public HttpLogFormatter curlFormatter() {
        return new CurlHttpLogFormatter();
    }

    @Bean
    @ConditionalOnBean(value={ObjectMapper.class})
    @ConditionalOnMissingBean(value={HttpLogFormatter.class})
    public HttpLogFormatter jsonFormatter(ObjectMapper mapper) {
        return new JsonHttpLogFormatter(mapper);
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpLogWriter.class})
    public HttpLogWriter writer(Logger httpLogger) {
        LogbookProperties.Write write = this.properties.getWrite();
        DefaultHttpLogWriter.Level level = write.getLevel();
        int size = write.getChunkSize();
        DefaultHttpLogWriter writer = new DefaultHttpLogWriter(httpLogger, level);
        return size > 0 ? new ChunkingHttpLogWriter(size, (HttpLogWriter)writer) : writer;
    }

    @Bean
    @ConditionalOnMissingBean(name={"httpLogger"})
    public Logger httpLogger() {
        return LoggerFactory.getLogger((String)this.properties.getWrite().getCategory());
    }

    @Configuration
    @ConditionalOnClass(value={SecurityFilterChain.class})
    @ConditionalOnWebApplication
    @AutoConfigureAfter(value={SecurityFilterAutoConfiguration.class})
    static class SecurityServletFilterConfiguration {
        private static final String FILTER_NAME = "unauthorizedLogbookFilter";

        SecurityServletFilterConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"logbook.filter.enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnMissingBean(name={"unauthorizedLogbookFilter"})
        public FilterRegistrationBean unauthorizedLogbookFilter(Logbook logbook) {
            LogbookFilter filter = new LogbookFilter(logbook, Strategy.SECURITY);
            FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
            registration.setName(FILTER_NAME);
            registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC, DispatcherType.ERROR});
            registration.setOrder(-2147483647);
            return registration;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Filter.class})
    @ConditionalOnWebApplication
    static class ServletFilterConfiguration {
        private static final String FILTER_NAME = "authorizedLogbookFilter";

        ServletFilterConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"logbook.filter.enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnMissingBean(name={"authorizedLogbookFilter"})
        public FilterRegistrationBean authorizedLogbookFilter(Logbook logbook) {
            LogbookFilter filter = new LogbookFilter(logbook);
            FilterRegistrationBean registration = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
            registration.setName(FILTER_NAME);
            registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC, DispatcherType.ERROR});
            registration.setOrder(Integer.MAX_VALUE);
            return registration;
        }
    }

    @Configuration
    @ConditionalOnClass(value={HttpClient.class, LogbookHttpRequestInterceptor.class, LogbookHttpResponseInterceptor.class})
    static class HttpClientAutoConfiguration {
        HttpClientAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={LogbookHttpRequestInterceptor.class})
        public LogbookHttpRequestInterceptor logbookHttpRequestInterceptor(Logbook logbook) {
            return new LogbookHttpRequestInterceptor(logbook);
        }

        @Bean
        @ConditionalOnMissingBean(value={LogbookHttpResponseInterceptor.class})
        public LogbookHttpResponseInterceptor logbookHttpResponseInterceptor() {
            return new LogbookHttpResponseInterceptor();
        }
    }
}

