/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.zeromq.ZAgent;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;
import org.zeromq.ZThread;

public class ZStar
implements ZAgent {
    private final ZContext context;
    private final ZAgent agent;
    private final Plateau plateau = new Plateau();

    public static void party(long time, TimeUnit unit) {
        LockSupport.parkNanos(TimeUnit.NANOSECONDS.convert(time, unit));
    }

    public ZAgent agent() {
        return this.agent;
    }

    public Exit exit() {
        return this.plateau;
    }

    public ZStar(Fortune actor, String lock, Object ... args) {
        this(new ZAgent.VerySimpleSelectorCreator(), actor, lock, args);
    }

    public ZStar(ZAgent.SelectorCreator selector, Fortune fortune, String motdelafin, Object ... args) {
        this(null, selector, fortune, motdelafin, args);
    }

    public ZStar(ZContext context, ZAgent.SelectorCreator selector, Fortune fortune, String motdelafin, Object ... bags) {
        assert (fortune != null);
        ZAgent.SelectorCreator feather = selector;
        if (selector == null) {
            feather = new ZAgent.VerySimpleSelectorCreator();
        }
        ZContext chef = context;
        ZContext producer = null;
        if (chef == null) {
            producer = chef = new ZContext();
        }
        this.context = chef;
        assert (this.context != null);
        Set set = null;
        Entourage entourage = null;
        for (Object bag : bags) {
            if (bag instanceof Set) {
                set = (Set)bag;
            }
            if (!(bag instanceof Entourage)) continue;
            entourage = (Entourage)bag;
        }
        if (set == null) {
            set = new SimpleSet();
        }
        ArrayList<Object> train = new ArrayList<Object>(6 + bags.length);
        train.add(set);
        train.add(fortune);
        train.add(feather);
        train.add(producer);
        train.add(entourage);
        train.add(motdelafin);
        train.addAll(Arrays.asList(bags));
        ZMQ.Socket phone = ZThread.fork(chef, this.plateau, train.toArray());
        this.agent = this.agent(phone, motdelafin);
    }

    protected ZAgent agent(ZMQ.Socket phone, String secret) {
        return ZAgent.Creator.create(phone, secret);
    }

    private ZContext context() {
        return this.context;
    }

    @Override
    public ZMsg recv() {
        return this.agent.recv();
    }

    @Override
    public ZMsg recv(int timeout) {
        return this.agent.recv(timeout);
    }

    @Override
    public ZMsg recv(boolean wait) {
        return this.agent.recv(wait);
    }

    @Override
    public boolean send(ZMsg message) {
        return this.agent.send(message);
    }

    @Override
    public boolean send(ZMsg msg, boolean destroy) {
        return this.agent.send(msg, destroy);
    }

    @Override
    public boolean send(String word) {
        return this.agent.send(word);
    }

    @Override
    public boolean send(String word, boolean more) {
        return this.agent.send(word, more);
    }

    @Override
    public ZMQ.Socket pipe() {
        return this.agent.pipe();
    }

    @Override
    public boolean sign() {
        return this.agent.sign();
    }

    @Override
    public void close() {
        this.agent.close();
    }

    public static interface Entourage
    extends TimeTaker {
        public void breakaleg(ZContext var1, Fortune var2, ZMQ.Socket var3, Object ... var4);
    }

    public static class SimpleSet
    implements Set {
        @Override
        public boolean fire() {
            return Thread.currentThread().isInterrupted();
        }

        @Override
        public void lights(String name, int id) {
            if (name == null) {
                name = SimpleSet.createDefaultName("Star-%d", id);
            }
            Thread.currentThread().setName(name);
        }

        public static String createDefaultName(String format, int id) {
            return String.format(format, id);
        }
    }

    public static interface Set {
        public void lights(String var1, int var2);

        public boolean fire();
    }

    private static final class Plateau
    implements ZThread.IAttachedRunnable,
    Exit {
        private static final AtomicInteger shows = new AtomicInteger();
        private final int number = shows.incrementAndGet();
        private final CountDownLatch exit = new CountDownLatch(1);

        private Plateau() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run(Object[] train, ZContext chef, ZMQ.Socket mic) {
            int mandat = 6;
            Fortune star = (Fortune)train[1];
            Entourage entourage = (Entourage)train[4];
            ZContext producer = (ZContext)train[3];
            ZAgent.SelectorCreator feather = (ZAgent.SelectorCreator)train[2];
            Set set = (Set)train[0];
            String gossip = (String)train[5];
            Object[] bags = new Object[train.length - 6];
            System.arraycopy(train, 6, bags, 0, bags.length);
            if (entourage != null) {
                entourage.breakaleg(chef, star, mic, bags);
            }
            Selector story = null;
            try {
                story = feather.create();
                String name = star.premiere(mic, bags);
                set.lights(name, this.number);
                this.showMustGoOn(chef, set, story, mic, star, bags);
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return;
            }
            finally {
                try {
                    boolean tell = star.interview(mic);
                    if (tell && gossip != null) {
                        try {
                            mic.send(gossip);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    star.party(chef);
                    star = null;
                    if (entourage != null) {
                        entourage.party(chef);
                    }
                    chef.close();
                    if (producer != null) {
                        producer.close();
                    }
                    feather.destroy(story);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    this.exit.countDown();
                }
            }
        }

        private void showMustGoOn(ZContext chef, Set set, Selector story, ZMQ.Socket phone, Fortune fortune, Object ... bags) {
            int shows = 0;
            Star actor = null;
            do {
                int events;
                actor = fortune.create(chef, phone, story, shows++, actor, bags);
                actor.prepare();
                while (!set.fire() && actor.act(events = actor.breathe()) && actor.entract()) {
                }
            } while (actor.renews());
        }

        @Override
        public void awaitSilent() {
            try {
                this.exit.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void await() throws InterruptedException {
            this.exit.await();
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.exit.await(timeout, unit);
        }

        @Override
        public boolean isExited() {
            return this.exit.getCount() == 0L;
        }
    }

    public static interface Exit {
        public void awaitSilent();

        public void await() throws InterruptedException;

        public boolean await(long var1, TimeUnit var3) throws InterruptedException;

        public boolean isExited();
    }

    public static interface Fortune
    extends TimeTaker {
        public String premiere(ZMQ.Socket var1, Object ... var2);

        public Star create(ZContext var1, ZMQ.Socket var2, Selector var3, int var4, Star var5, Object ... var6);

        public boolean interview(ZMQ.Socket var1);
    }

    public static interface TimeTaker {
        public void party(ZContext var1);
    }

    public static interface Star {
        public void prepare();

        public int breathe();

        public boolean act(int var1);

        public boolean entract();

        public boolean renews();
    }
}

