/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.RedisInputStream;
import redis.clients.util.RedisOutputStream;
import redis.clients.util.SafeEncoder;

public class Connection {
    private String host;
    private int port = 6379;
    private Socket socket;
    private RedisOutputStream outputStream;
    private RedisInputStream inputStream;
    private int pipelinedCommands = 0;
    private int timeout = 2000;

    public Socket getSocket() {
        return this.socket;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTimeoutInfinite() {
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            this.socket.setKeepAlive(true);
            this.socket.setSoTimeout(0);
        }
        catch (SocketException ex) {
            throw new JedisException(ex);
        }
    }

    public void rollbackTimeout() {
        try {
            this.socket.setSoTimeout(this.timeout);
            this.socket.setKeepAlive(false);
        }
        catch (SocketException ex) {
            throw new JedisException(ex);
        }
    }

    public Connection(String host) {
        this.host = host;
    }

    protected void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new JedisConnectionException(e);
        }
    }

    protected Connection sendCommand(Protocol.Command cmd, String ... args) {
        byte[][] bargs = new byte[args.length][];
        for (int i = 0; i < args.length; ++i) {
            bargs[i] = SafeEncoder.encode(args[i]);
        }
        return this.sendCommand(cmd, bargs);
    }

    protected Connection sendCommand(Protocol.Command cmd, byte[] ... args) {
        this.connect();
        Protocol.sendCommand(this.outputStream, cmd, args);
        ++this.pipelinedCommands;
        return this;
    }

    protected Connection sendCommand(Protocol.Command cmd) {
        this.connect();
        Protocol.sendCommand(this.outputStream, cmd, (byte[][])new byte[0][]);
        ++this.pipelinedCommands;
        return this;
    }

    public Connection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Connection() {
    }

    public void connect() {
        if (!this.isConnected()) {
            try {
                this.socket = new Socket();
                this.socket.setReuseAddress(true);
                this.socket.setKeepAlive(true);
                this.socket.setTcpNoDelay(true);
                this.socket.setSoLinger(true, 0);
                this.socket.connect(new InetSocketAddress(this.host, this.port), this.timeout);
                this.socket.setSoTimeout(this.timeout);
                this.outputStream = new RedisOutputStream(this.socket.getOutputStream());
                this.inputStream = new RedisInputStream(this.socket.getInputStream());
            }
            catch (IOException ex) {
                throw new JedisConnectionException(ex);
            }
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.inputStream.close();
                this.outputStream.close();
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException ex) {
                throw new JedisConnectionException(ex);
            }
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    protected String getStatusCodeReply() {
        this.flush();
        --this.pipelinedCommands;
        byte[] resp = (byte[])Protocol.read(this.inputStream);
        if (null == resp) {
            return null;
        }
        return SafeEncoder.encode(resp);
    }

    public String getBulkReply() {
        byte[] result = this.getBinaryBulkReply();
        if (null != result) {
            return SafeEncoder.encode(result);
        }
        return null;
    }

    public byte[] getBinaryBulkReply() {
        this.flush();
        --this.pipelinedCommands;
        return (byte[])Protocol.read(this.inputStream);
    }

    public Long getIntegerReply() {
        this.flush();
        --this.pipelinedCommands;
        return (Long)Protocol.read(this.inputStream);
    }

    public List<String> getMultiBulkReply() {
        return BuilderFactory.STRING_LIST.build(this.getBinaryMultiBulkReply());
    }

    public List<byte[]> getBinaryMultiBulkReply() {
        this.flush();
        --this.pipelinedCommands;
        return (List)Protocol.read(this.inputStream);
    }

    public List<Object> getObjectMultiBulkReply() {
        this.flush();
        --this.pipelinedCommands;
        return (List)Protocol.read(this.inputStream);
    }

    public List<Long> getIntegerMultiBulkReply() {
        this.flush();
        --this.pipelinedCommands;
        return (List)Protocol.read(this.inputStream);
    }

    public List<Object> getAll() {
        return this.getAll(0);
    }

    public List<Object> getAll(int except) {
        ArrayList<Object> all = new ArrayList<Object>();
        this.flush();
        while (this.pipelinedCommands > except) {
            try {
                all.add(Protocol.read(this.inputStream));
            }
            catch (JedisDataException e) {
                all.add(e);
            }
            --this.pipelinedCommands;
        }
        return all;
    }

    public Object getOne() {
        this.flush();
        --this.pipelinedCommands;
        return Protocol.read(this.inputStream);
    }
}

