/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.args;

import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.util.SafeEncoder;

public final class RawableFactory {
    public static Rawable from(byte[] binary) {
        return new Raw(binary);
    }

    public static Rawable from(String string) {
        return new RawString(string);
    }

    private RawableFactory() {
        throw new InstantiationError();
    }

    public static class RawString
    extends Raw {
        public RawString(String str) {
            super(SafeEncoder.encode(str));
        }
    }

    public static class Raw
    implements Rawable {
        private final byte[] raw;

        public Raw(byte[] raw) {
            this.raw = raw;
        }

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }
}

