/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.util.SafeEncoder;

public class Document
implements Serializable {
    private static final long serialVersionUID = 4884173545291367373L;
    private final String id;
    private double score;
    private byte[] payload;
    private final Map<String, Object> properties;

    public Document(String id, double score) {
        this(id, new HashMap<String, Object>(), score);
    }

    public Document(String id) {
        this(id, 1.0);
    }

    public Document(String id, Map<String, Object> fields) {
        this(id, fields, 1.0);
    }

    public Document(String id, Map<String, Object> fields, double score) {
        this(id, fields, score, null);
    }

    public Document(String id, Map<String, Object> fields, double score, byte[] payload) {
        this.id = id;
        this.properties = new HashMap<String, Object>(fields);
        this.score = score;
        this.payload = payload;
    }

    public Iterable<Map.Entry<String, Object>> getProperties() {
        return this.properties.entrySet();
    }

    public static Document load(String id, double score, byte[] payload, List<byte[]> fields) {
        return Document.load(id, score, payload, fields, true);
    }

    public static Document load(String id, double score, byte[] payload, List<byte[]> fields, boolean decode) {
        Document ret = new Document(id, score);
        ret.payload = payload;
        if (fields != null) {
            for (int i = 0; i < fields.size(); i += 2) {
                byte[] rawKey = fields.get(i);
                byte[] rawValue = fields.get(i + 1);
                String key = SafeEncoder.encode(rawKey);
                byte[] value = rawValue == null ? null : (decode ? (Object)SafeEncoder.encode(rawValue) : rawValue);
                ret.set(key, value);
            }
        }
        return ret;
    }

    public Document set(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public String getString(String key) {
        Object value = this.properties.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return value instanceof byte[] ? SafeEncoder.encode((byte[])value) : value.toString();
    }

    public double getScore() {
        return this.score;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public Document setScore(float score) {
        this.score = score;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public String toString() {
        return "id:" + this.getId() + ", score: " + this.getScore() + ", payload:" + (this.getPayload() == null ? "null" : SafeEncoder.encode(this.getPayload())) + ", properties:" + this.getProperties();
    }
}

