/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class AccessControlUser {
    private final Map<String, Object> userInfo;
    private final List<String> flags;
    private final List<String> passwords;
    private final String commands;
    private final List<String> keysList;
    private final String keys;
    private final List<String> channelsList;
    private final String channels;
    private final List<String> selectors;

    public AccessControlUser(Map<String, Object> map) {
        this.userInfo = map;
        this.flags = (List)map.get("flags");
        this.passwords = (List)map.get("passwords");
        this.commands = (String)map.get("commands");
        Object localKeys = map.get("keys");
        if (localKeys == null) {
            this.keys = null;
            this.keysList = null;
        } else if (localKeys instanceof List) {
            this.keysList = (List)localKeys;
            this.keys = AccessControlUser.joinStrings(this.keysList);
        } else {
            this.keys = (String)localKeys;
            this.keysList = Arrays.asList(this.keys.split(" "));
        }
        Object localChannels = map.get("channels");
        if (localChannels == null) {
            this.channels = null;
            this.channelsList = null;
        } else if (localChannels instanceof List) {
            this.channelsList = (List)localChannels;
            this.channels = AccessControlUser.joinStrings(this.channelsList);
        } else {
            this.channels = (String)localChannels;
            this.channelsList = Arrays.asList(this.channels.split(" "));
        }
        this.selectors = (List)map.get("selectors");
    }

    private static String joinStrings(List<String> list) {
        StringJoiner joiner = new StringJoiner(" ");
        list.forEach(s -> joiner.add((CharSequence)s));
        return joiner.toString();
    }

    public List<String> getFlags() {
        return this.flags;
    }

    @Deprecated
    public List<String> getPassword() {
        return this.passwords;
    }

    public List<String> getPasswords() {
        return this.passwords;
    }

    public String getCommands() {
        return this.commands;
    }

    public Map<String, Object> getUserInfo() {
        return this.userInfo;
    }

    public String getKeys() {
        return this.keys;
    }

    public List<String> getKeysList() {
        return this.keysList;
    }

    public List<String> getChannelsList() {
        return this.channelsList;
    }

    public String getChannels() {
        return this.channels;
    }

    public List<String> getSelectors() {
        return this.selectors;
    }

    public String toString() {
        return "AccessControlUser{flags=" + this.flags + ", passwords=" + this.passwords + ", commands='" + this.commands + "', keys='" + this.keys + "', channels='" + this.channels + "', selectors=" + this.selectors + "}";
    }
}

