/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.SAPODataPaginationConfig;
import software.amazon.awssdk.services.appflow.model.SAPODataParallelismConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SAPODataSourceProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SAPODataSourceProperties> {
    private static final SdkField<String> OBJECT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectPath").getter(SAPODataSourceProperties.getter(SAPODataSourceProperties::objectPath)).setter(SAPODataSourceProperties.setter(Builder::objectPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectPath").build()}).build();
    private static final SdkField<SAPODataParallelismConfig> PARALLELISM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parallelismConfig").getter(SAPODataSourceProperties.getter(SAPODataSourceProperties::parallelismConfig)).setter(SAPODataSourceProperties.setter(Builder::parallelismConfig)).constructor(SAPODataParallelismConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelismConfig").build()}).build();
    private static final SdkField<SAPODataPaginationConfig> PAGINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("paginationConfig").getter(SAPODataSourceProperties.getter(SAPODataSourceProperties::paginationConfig)).setter(SAPODataSourceProperties.setter(Builder::paginationConfig)).constructor(SAPODataPaginationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paginationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_PATH_FIELD, PARALLELISM_CONFIG_FIELD, PAGINATION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SAPODataSourceProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String objectPath;
    private final SAPODataParallelismConfig parallelismConfig;
    private final SAPODataPaginationConfig paginationConfig;

    private SAPODataSourceProperties(BuilderImpl builder) {
        this.objectPath = builder.objectPath;
        this.parallelismConfig = builder.parallelismConfig;
        this.paginationConfig = builder.paginationConfig;
    }

    public final String objectPath() {
        return this.objectPath;
    }

    public final SAPODataParallelismConfig parallelismConfig() {
        return this.parallelismConfig;
    }

    public final SAPODataPaginationConfig paginationConfig() {
        return this.paginationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelismConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAPODataSourceProperties)) {
            return false;
        }
        SAPODataSourceProperties other = (SAPODataSourceProperties)obj;
        return Objects.equals(this.objectPath(), other.objectPath()) && Objects.equals(this.parallelismConfig(), other.parallelismConfig()) && Objects.equals(this.paginationConfig(), other.paginationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"SAPODataSourceProperties").add("ObjectPath", (Object)this.objectPath()).add("ParallelismConfig", (Object)this.parallelismConfig()).add("PaginationConfig", (Object)this.paginationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "objectPath": {
                return Optional.ofNullable(clazz.cast(this.objectPath()));
            }
            case "parallelismConfig": {
                return Optional.ofNullable(clazz.cast(this.parallelismConfig()));
            }
            case "paginationConfig": {
                return Optional.ofNullable(clazz.cast(this.paginationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("objectPath", OBJECT_PATH_FIELD);
        map.put("parallelismConfig", PARALLELISM_CONFIG_FIELD);
        map.put("paginationConfig", PAGINATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SAPODataSourceProperties, T> g) {
        return obj -> g.apply((SAPODataSourceProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String objectPath;
        private SAPODataParallelismConfig parallelismConfig;
        private SAPODataPaginationConfig paginationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SAPODataSourceProperties model) {
            this.objectPath(model.objectPath);
            this.parallelismConfig(model.parallelismConfig);
            this.paginationConfig(model.paginationConfig);
        }

        public final String getObjectPath() {
            return this.objectPath;
        }

        public final void setObjectPath(String objectPath) {
            this.objectPath = objectPath;
        }

        @Override
        public final Builder objectPath(String objectPath) {
            this.objectPath = objectPath;
            return this;
        }

        public final SAPODataParallelismConfig.Builder getParallelismConfig() {
            return this.parallelismConfig != null ? this.parallelismConfig.toBuilder() : null;
        }

        public final void setParallelismConfig(SAPODataParallelismConfig.BuilderImpl parallelismConfig) {
            this.parallelismConfig = parallelismConfig != null ? parallelismConfig.build() : null;
        }

        @Override
        public final Builder parallelismConfig(SAPODataParallelismConfig parallelismConfig) {
            this.parallelismConfig = parallelismConfig;
            return this;
        }

        public final SAPODataPaginationConfig.Builder getPaginationConfig() {
            return this.paginationConfig != null ? this.paginationConfig.toBuilder() : null;
        }

        public final void setPaginationConfig(SAPODataPaginationConfig.BuilderImpl paginationConfig) {
            this.paginationConfig = paginationConfig != null ? paginationConfig.build() : null;
        }

        @Override
        public final Builder paginationConfig(SAPODataPaginationConfig paginationConfig) {
            this.paginationConfig = paginationConfig;
            return this;
        }

        public SAPODataSourceProperties build() {
            return new SAPODataSourceProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SAPODataSourceProperties> {
        public Builder objectPath(String var1);

        public Builder parallelismConfig(SAPODataParallelismConfig var1);

        default public Builder parallelismConfig(Consumer<SAPODataParallelismConfig.Builder> parallelismConfig) {
            return this.parallelismConfig((SAPODataParallelismConfig)((SAPODataParallelismConfig.Builder)SAPODataParallelismConfig.builder().applyMutation(parallelismConfig)).build());
        }

        public Builder paginationConfig(SAPODataPaginationConfig var1);

        default public Builder paginationConfig(Consumer<SAPODataPaginationConfig.Builder> paginationConfig) {
            return this.paginationConfig((SAPODataPaginationConfig)((SAPODataPaginationConfig.Builder)SAPODataPaginationConfig.builder().applyMutation(paginationConfig)).build());
        }
    }
}

