/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsAsyncClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse;

public class ListDataIntegrationsPublisher
implements SdkPublisher<ListDataIntegrationsResponse> {
    private final AppIntegrationsAsyncClient client;
    private final ListDataIntegrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataIntegrationsPublisher(AppIntegrationsAsyncClient client, ListDataIntegrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataIntegrationsPublisher(AppIntegrationsAsyncClient client, ListDataIntegrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataIntegrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataIntegrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataIntegrationSummary> dataIntegrations() {
        Function<ListDataIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataIntegrations() != null) {
                return response.dataIntegrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataIntegrationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataIntegrationsResponseFetcher
    implements AsyncPageFetcher<ListDataIntegrationsResponse> {
        private ListDataIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataIntegrationsResponse> nextPage(ListDataIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIntegrationsPublisher.this.client.listDataIntegrations(ListDataIntegrationsPublisher.this.firstRequest);
            }
            return ListDataIntegrationsPublisher.this.client.listDataIntegrations((ListDataIntegrationsRequest)((Object)ListDataIntegrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

