/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteAgent;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteAgentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteAgentsRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, BatchDeleteAgentsRequest> {
    private static final SdkField<List<DeleteAgent>> DELETE_AGENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deleteAgents").getter(BatchDeleteAgentsRequest.getter(BatchDeleteAgentsRequest::deleteAgents)).setter(BatchDeleteAgentsRequest.setter(Builder::deleteAgents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteAgents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteAgent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_AGENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteAgentsRequest.memberNameToFieldInitializer();
    private final List<DeleteAgent> deleteAgents;

    private BatchDeleteAgentsRequest(BuilderImpl builder) {
        super(builder);
        this.deleteAgents = builder.deleteAgents;
    }

    public final boolean hasDeleteAgents() {
        return this.deleteAgents != null && !(this.deleteAgents instanceof SdkAutoConstructList);
    }

    public final List<DeleteAgent> deleteAgents() {
        return this.deleteAgents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeleteAgents() ? this.deleteAgents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteAgentsRequest)) {
            return false;
        }
        BatchDeleteAgentsRequest other = (BatchDeleteAgentsRequest)((Object)obj);
        return this.hasDeleteAgents() == other.hasDeleteAgents() && Objects.equals(this.deleteAgents(), other.deleteAgents());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteAgentsRequest").add("DeleteAgents", this.hasDeleteAgents() ? this.deleteAgents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deleteAgents": {
                return Optional.ofNullable(clazz.cast(this.deleteAgents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DeleteAgent>>> map = new HashMap<String, SdkField<List<DeleteAgent>>>();
        map.put("deleteAgents", DELETE_AGENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteAgentsRequest, T> g) {
        return obj -> g.apply((BatchDeleteAgentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private List<DeleteAgent> deleteAgents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteAgentsRequest model) {
            super(model);
            this.deleteAgents(model.deleteAgents);
        }

        public final List<DeleteAgent.Builder> getDeleteAgents() {
            List<DeleteAgent.Builder> result = DeleteAgentsCopier.copyToBuilder(this.deleteAgents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeleteAgents(Collection<DeleteAgent.BuilderImpl> deleteAgents) {
            this.deleteAgents = DeleteAgentsCopier.copyFromBuilder(deleteAgents);
        }

        @Override
        public final Builder deleteAgents(Collection<DeleteAgent> deleteAgents) {
            this.deleteAgents = DeleteAgentsCopier.copy(deleteAgents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteAgents(DeleteAgent ... deleteAgents) {
            this.deleteAgents(Arrays.asList(deleteAgents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteAgents(Consumer<DeleteAgent.Builder> ... deleteAgents) {
            this.deleteAgents(Stream.of(deleteAgents).map(c -> (DeleteAgent)((DeleteAgent.Builder)DeleteAgent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteAgentsRequest build() {
            return new BatchDeleteAgentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteAgentsRequest> {
        public Builder deleteAgents(Collection<DeleteAgent> var1);

        public Builder deleteAgents(DeleteAgent ... var1);

        public Builder deleteAgents(Consumer<DeleteAgent.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

