/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImportTaskFilterName {
    IMPORT_TASK_ID("IMPORT_TASK_ID"),
    STATUS("STATUS"),
    NAME("NAME"),
    FILE_CLASSIFICATION("FILE_CLASSIFICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportTaskFilterName> VALUE_MAP;
    private final String value;

    private ImportTaskFilterName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportTaskFilterName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportTaskFilterName> knownValues() {
        EnumSet<ImportTaskFilterName> knownValues = EnumSet.allOf(ImportTaskFilterName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImportTaskFilterName.class, ImportTaskFilterName::toString);
    }
}

