/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.AppMeshRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGatewayRouteRequest
extends AppMeshRequest
implements ToCopyableBuilder<Builder, DescribeGatewayRouteRequest> {
    private static final SdkField<String> GATEWAY_ROUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayRouteName").getter(DescribeGatewayRouteRequest.getter(DescribeGatewayRouteRequest::gatewayRouteName)).setter(DescribeGatewayRouteRequest.setter(Builder::gatewayRouteName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayRouteName").build()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshName").getter(DescribeGatewayRouteRequest.getter(DescribeGatewayRouteRequest::meshName)).setter(DescribeGatewayRouteRequest.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()}).build();
    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshOwner").getter(DescribeGatewayRouteRequest.getter(DescribeGatewayRouteRequest::meshOwner)).setter(DescribeGatewayRouteRequest.setter(Builder::meshOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()}).build();
    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualGatewayName").getter(DescribeGatewayRouteRequest.getter(DescribeGatewayRouteRequest::virtualGatewayName)).setter(DescribeGatewayRouteRequest.setter(Builder::virtualGatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualGatewayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ROUTE_NAME_FIELD, MESH_NAME_FIELD, MESH_OWNER_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGatewayRouteRequest.memberNameToFieldInitializer();
    private final String gatewayRouteName;
    private final String meshName;
    private final String meshOwner;
    private final String virtualGatewayName;

    private DescribeGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayRouteName = builder.gatewayRouteName;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    public final String gatewayRouteName() {
        return this.gatewayRouteName;
    }

    public final String meshName() {
        return this.meshName;
    }

    public final String meshOwner() {
        return this.meshOwner;
    }

    public final String virtualGatewayName() {
        return this.virtualGatewayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayRouteName());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGatewayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayRouteRequest)) {
            return false;
        }
        DescribeGatewayRouteRequest other = (DescribeGatewayRouteRequest)((Object)obj);
        return Objects.equals(this.gatewayRouteName(), other.gatewayRouteName()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.meshOwner(), other.meshOwner()) && Objects.equals(this.virtualGatewayName(), other.virtualGatewayName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGatewayRouteRequest").add("GatewayRouteName", (Object)this.gatewayRouteName()).add("MeshName", (Object)this.meshName()).add("MeshOwner", (Object)this.meshOwner()).add("VirtualGatewayName", (Object)this.virtualGatewayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayRouteName": {
                return Optional.ofNullable(clazz.cast(this.gatewayRouteName()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "meshOwner": {
                return Optional.ofNullable(clazz.cast(this.meshOwner()));
            }
            case "virtualGatewayName": {
                return Optional.ofNullable(clazz.cast(this.virtualGatewayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("gatewayRouteName", GATEWAY_ROUTE_NAME_FIELD);
        map.put("meshName", MESH_NAME_FIELD);
        map.put("meshOwner", MESH_OWNER_FIELD);
        map.put("virtualGatewayName", VIRTUAL_GATEWAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayRouteRequest, T> g) {
        return obj -> g.apply((DescribeGatewayRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshRequest.BuilderImpl
    implements Builder {
        private String gatewayRouteName;
        private String meshName;
        private String meshOwner;
        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayRouteRequest model) {
            super(model);
            this.gatewayRouteName(model.gatewayRouteName);
            this.meshName(model.meshName);
            this.meshOwner(model.meshOwner);
            this.virtualGatewayName(model.virtualGatewayName);
        }

        public final String getGatewayRouteName() {
            return this.gatewayRouteName;
        }

        public final void setGatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
        }

        @Override
        public final Builder gatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final String getMeshOwner() {
            return this.meshOwner;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final String getVirtualGatewayName() {
            return this.virtualGatewayName;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        @Override
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGatewayRouteRequest build() {
            return new DescribeGatewayRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppMeshRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGatewayRouteRequest> {
        public Builder gatewayRouteName(String var1);

        public Builder meshName(String var1);

        public Builder meshOwner(String var1);

        public Builder virtualGatewayName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

