/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.AppRunnerResponse;
import software.amazon.awssdk.services.apprunner.model.VpcConnector;
import software.amazon.awssdk.services.apprunner.model.VpcConnectorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVpcConnectorsResponse
extends AppRunnerResponse
implements ToCopyableBuilder<Builder, ListVpcConnectorsResponse> {
    private static final SdkField<List<VpcConnector>> VPC_CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcConnectors").getter(ListVpcConnectorsResponse.getter(ListVpcConnectorsResponse::vpcConnectors)).setter(ListVpcConnectorsResponse.setter(Builder::vpcConnectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcConnector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVpcConnectorsResponse.getter(ListVpcConnectorsResponse::nextToken)).setter(ListVpcConnectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVpcConnectorsResponse.memberNameToFieldInitializer();
    private final List<VpcConnector> vpcConnectors;
    private final String nextToken;

    private ListVpcConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcConnectors = builder.vpcConnectors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVpcConnectors() {
        return this.vpcConnectors != null && !(this.vpcConnectors instanceof SdkAutoConstructList);
    }

    public final List<VpcConnector> vpcConnectors() {
        return this.vpcConnectors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcConnectors() ? this.vpcConnectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcConnectorsResponse)) {
            return false;
        }
        ListVpcConnectorsResponse other = (ListVpcConnectorsResponse)((Object)obj);
        return this.hasVpcConnectors() == other.hasVpcConnectors() && Objects.equals(this.vpcConnectors(), other.vpcConnectors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVpcConnectorsResponse").add("VpcConnectors", this.hasVpcConnectors() ? this.vpcConnectors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcConnectors": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectors()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcConnectors", VPC_CONNECTORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVpcConnectorsResponse, T> g) {
        return obj -> g.apply((ListVpcConnectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerResponse.BuilderImpl
    implements Builder {
        private List<VpcConnector> vpcConnectors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcConnectorsResponse model) {
            super(model);
            this.vpcConnectors(model.vpcConnectors);
            this.nextToken(model.nextToken);
        }

        public final List<VpcConnector.Builder> getVpcConnectors() {
            List<VpcConnector.Builder> result = VpcConnectorsCopier.copyToBuilder(this.vpcConnectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcConnectors(Collection<VpcConnector.BuilderImpl> vpcConnectors) {
            this.vpcConnectors = VpcConnectorsCopier.copyFromBuilder(vpcConnectors);
        }

        @Override
        public final Builder vpcConnectors(Collection<VpcConnector> vpcConnectors) {
            this.vpcConnectors = VpcConnectorsCopier.copy(vpcConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnectors(VpcConnector ... vpcConnectors) {
            this.vpcConnectors(Arrays.asList(vpcConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnectors(Consumer<VpcConnector.Builder> ... vpcConnectors) {
            this.vpcConnectors(Stream.of(vpcConnectors).map(c -> (VpcConnector)((VpcConnector.Builder)VpcConnector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVpcConnectorsResponse build() {
            return new ListVpcConnectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppRunnerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVpcConnectorsResponse> {
        public Builder vpcConnectors(Collection<VpcConnector> var1);

        public Builder vpcConnectors(VpcConnector ... var1);

        public Builder vpcConnectors(Consumer<VpcConnector.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

