/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceObservabilityConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceObservabilityConfiguration> {
    private static final SdkField<Boolean> OBSERVABILITY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ObservabilityEnabled").getter(ServiceObservabilityConfiguration.getter(ServiceObservabilityConfiguration::observabilityEnabled)).setter(ServiceObservabilityConfiguration.setter(Builder::observabilityEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityEnabled").build()}).build();
    private static final SdkField<String> OBSERVABILITY_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObservabilityConfigurationArn").getter(ServiceObservabilityConfiguration.getter(ServiceObservabilityConfiguration::observabilityConfigurationArn)).setter(ServiceObservabilityConfiguration.setter(Builder::observabilityConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBSERVABILITY_ENABLED_FIELD, OBSERVABILITY_CONFIGURATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceObservabilityConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean observabilityEnabled;
    private final String observabilityConfigurationArn;

    private ServiceObservabilityConfiguration(BuilderImpl builder) {
        this.observabilityEnabled = builder.observabilityEnabled;
        this.observabilityConfigurationArn = builder.observabilityConfigurationArn;
    }

    public final Boolean observabilityEnabled() {
        return this.observabilityEnabled;
    }

    public final String observabilityConfigurationArn() {
        return this.observabilityConfigurationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.observabilityEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.observabilityConfigurationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceObservabilityConfiguration)) {
            return false;
        }
        ServiceObservabilityConfiguration other = (ServiceObservabilityConfiguration)obj;
        return Objects.equals(this.observabilityEnabled(), other.observabilityEnabled()) && Objects.equals(this.observabilityConfigurationArn(), other.observabilityConfigurationArn());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceObservabilityConfiguration").add("ObservabilityEnabled", (Object)this.observabilityEnabled()).add("ObservabilityConfigurationArn", (Object)this.observabilityConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObservabilityEnabled": {
                return Optional.ofNullable(clazz.cast(this.observabilityEnabled()));
            }
            case "ObservabilityConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.observabilityConfigurationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ObservabilityEnabled", OBSERVABILITY_ENABLED_FIELD);
        map.put("ObservabilityConfigurationArn", OBSERVABILITY_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceObservabilityConfiguration, T> g) {
        return obj -> g.apply((ServiceObservabilityConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean observabilityEnabled;
        private String observabilityConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceObservabilityConfiguration model) {
            this.observabilityEnabled(model.observabilityEnabled);
            this.observabilityConfigurationArn(model.observabilityConfigurationArn);
        }

        public final Boolean getObservabilityEnabled() {
            return this.observabilityEnabled;
        }

        public final void setObservabilityEnabled(Boolean observabilityEnabled) {
            this.observabilityEnabled = observabilityEnabled;
        }

        @Override
        public final Builder observabilityEnabled(Boolean observabilityEnabled) {
            this.observabilityEnabled = observabilityEnabled;
            return this;
        }

        public final String getObservabilityConfigurationArn() {
            return this.observabilityConfigurationArn;
        }

        public final void setObservabilityConfigurationArn(String observabilityConfigurationArn) {
            this.observabilityConfigurationArn = observabilityConfigurationArn;
        }

        @Override
        public final Builder observabilityConfigurationArn(String observabilityConfigurationArn) {
            this.observabilityConfigurationArn = observabilityConfigurationArn;
            return this;
        }

        public ServiceObservabilityConfiguration build() {
            return new ServiceObservabilityConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceObservabilityConfiguration> {
        public Builder observabilityEnabled(Boolean var1);

        public Builder observabilityConfigurationArn(String var1);
    }
}

