/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Dimension {
    AZ("AZ"),
    INSTANCE_TYPE("INSTANCE_TYPE"),
    LINKED_ACCOUNT("LINKED_ACCOUNT"),
    OPERATION("OPERATION"),
    PURCHASE_TYPE("PURCHASE_TYPE"),
    REGION("REGION"),
    SERVICE("SERVICE"),
    USAGE_TYPE("USAGE_TYPE"),
    USAGE_TYPE_GROUP("USAGE_TYPE_GROUP"),
    RECORD_TYPE("RECORD_TYPE"),
    RESOURCE_ID("RESOURCE_ID"),
    SUBSCRIPTION_ID("SUBSCRIPTION_ID"),
    TAG_KEY("TAG_KEY"),
    OPERATING_SYSTEM("OPERATING_SYSTEM"),
    TENANCY("TENANCY"),
    BILLING_ENTITY("BILLING_ENTITY"),
    RESERVATION_ID("RESERVATION_ID"),
    COST_CATEGORY_NAME("COST_CATEGORY_NAME"),
    DATABASE_ENGINE("DATABASE_ENGINE"),
    LEGAL_ENTITY_NAME("LEGAL_ENTITY_NAME"),
    SAVINGS_PLANS_TYPE("SAVINGS_PLANS_TYPE"),
    INSTANCE_TYPE_FAMILY("INSTANCE_TYPE_FAMILY"),
    CACHE_ENGINE("CACHE_ENGINE"),
    DEPLOYMENT_OPTION("DEPLOYMENT_OPTION"),
    SCOPE("SCOPE"),
    PLATFORM("PLATFORM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Dimension> VALUE_MAP;
    private final String value;

    private Dimension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Dimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Dimension> knownValues() {
        EnumSet<Dimension> knownValues = EnumSet.allOf(Dimension.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Dimension.class, Dimension::toString);
    }
}

