/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdashboards.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmdashboards.model.BcmDashboardsResponse;
import software.amazon.awssdk.services.bcmdashboards.model.DashboardReference;
import software.amazon.awssdk.services.bcmdashboards.model.DashboardReferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDashboardsResponse
extends BcmDashboardsResponse
implements ToCopyableBuilder<Builder, ListDashboardsResponse> {
    private static final SdkField<List<DashboardReference>> DASHBOARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dashboards").getter(ListDashboardsResponse.getter(ListDashboardsResponse::dashboards)).setter(ListDashboardsResponse.setter(Builder::dashboards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashboardReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDashboardsResponse.getter(ListDashboardsResponse::nextToken)).setter(ListDashboardsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDashboardsResponse.memberNameToFieldInitializer();
    private final List<DashboardReference> dashboards;
    private final String nextToken;

    private ListDashboardsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboards = builder.dashboards;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDashboards() {
        return this.dashboards != null && !(this.dashboards instanceof SdkAutoConstructList);
    }

    public final List<DashboardReference> dashboards() {
        return this.dashboards;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashboards() ? this.dashboards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsResponse)) {
            return false;
        }
        ListDashboardsResponse other = (ListDashboardsResponse)((Object)obj);
        return this.hasDashboards() == other.hasDashboards() && Objects.equals(this.dashboards(), other.dashboards()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDashboardsResponse").add("Dashboards", this.hasDashboards() ? this.dashboards() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dashboards": {
                return Optional.ofNullable(clazz.cast(this.dashboards()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dashboards", DASHBOARDS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDashboardsResponse, T> g) {
        return obj -> g.apply((ListDashboardsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmDashboardsResponse.BuilderImpl
    implements Builder {
        private List<DashboardReference> dashboards = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsResponse model) {
            super(model);
            this.dashboards(model.dashboards);
            this.nextToken(model.nextToken);
        }

        public final List<DashboardReference.Builder> getDashboards() {
            List<DashboardReference.Builder> result = DashboardReferenceListCopier.copyToBuilder(this.dashboards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashboards(Collection<DashboardReference.BuilderImpl> dashboards) {
            this.dashboards = DashboardReferenceListCopier.copyFromBuilder(dashboards);
        }

        @Override
        public final Builder dashboards(Collection<DashboardReference> dashboards) {
            this.dashboards = DashboardReferenceListCopier.copy(dashboards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboards(DashboardReference ... dashboards) {
            this.dashboards(Arrays.asList(dashboards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboards(Consumer<DashboardReference.Builder> ... dashboards) {
            this.dashboards(Stream.of(dashboards).map(c -> (DashboardReference)((DashboardReference.Builder)DashboardReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDashboardsResponse build() {
            return new ListDashboardsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BcmDashboardsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDashboardsResponse> {
        public Builder dashboards(Collection<DashboardReference> var1);

        public Builder dashboards(DashboardReference ... var1);

        public Builder dashboards(Consumer<DashboardReference.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

