/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.HistoricalUsageEntity;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UsageQuantitiesCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UsageQuantity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillScenarioUsageModificationItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillScenarioUsageModificationItem> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceCode").getter(BillScenarioUsageModificationItem.getter(BillScenarioUsageModificationItem::serviceCode)).setter(BillScenarioUsageModificationItem.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(BillScenarioUsageModificationItem.getter(BillScenarioUsageModificationItem::usageType)).setter(BillScenarioUsageModificationItem.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operation").getter(BillScenarioUsageModificationItem.getter(BillScenarioUsageModificationItem::operation)).setter(BillScenarioUsageModificationItem.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(BillScenarioUsageModificationItem.getter(BillScenarioUsageModificationItem::location)).setter(BillScenarioUsageModificationItem.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(BillScenarioUsageModificationItem.getter(BillScenarioUsageModificationItem::availabilityZone)).setter(BillScenarioUsageModificationItem.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(BillScenarioUsageModificationItem.getter(BillScenarioUsageModificationItem::id)).setter(BillScenarioUsageModificationItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("group").getter(BillScenarioUsageModificationItem.getter(BillScenarioUsageModificationItem::group)).setter(BillScenarioUsageModificationItem.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageAccountId").getter(BillScenarioUsageModificationItem.getter(BillScenarioUsageModificationItem::usageAccountId)).setter(BillScenarioUsageModificationItem.setter(Builder::usageAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()}).build();
    private static final SdkField<List<UsageQuantity>> QUANTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("quantities").getter(BillScenarioUsageModificationItem.getter(BillScenarioUsageModificationItem::quantities)).setter(BillScenarioUsageModificationItem.setter(Builder::quantities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageQuantity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HistoricalUsageEntity> HISTORICAL_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("historicalUsage").getter(BillScenarioUsageModificationItem.getter(BillScenarioUsageModificationItem::historicalUsage)).setter(BillScenarioUsageModificationItem.setter(Builder::historicalUsage)).constructor(HistoricalUsageEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalUsage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD, LOCATION_FIELD, AVAILABILITY_ZONE_FIELD, ID_FIELD, GROUP_FIELD, USAGE_ACCOUNT_ID_FIELD, QUANTITIES_FIELD, HISTORICAL_USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BillScenarioUsageModificationItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceCode;
    private final String usageType;
    private final String operation;
    private final String location;
    private final String availabilityZone;
    private final String id;
    private final String group;
    private final String usageAccountId;
    private final List<UsageQuantity> quantities;
    private final HistoricalUsageEntity historicalUsage;

    private BillScenarioUsageModificationItem(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.location = builder.location;
        this.availabilityZone = builder.availabilityZone;
        this.id = builder.id;
        this.group = builder.group;
        this.usageAccountId = builder.usageAccountId;
        this.quantities = builder.quantities;
        this.historicalUsage = builder.historicalUsage;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String usageType() {
        return this.usageType;
    }

    public final String operation() {
        return this.operation;
    }

    public final String location() {
        return this.location;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String id() {
        return this.id;
    }

    public final String group() {
        return this.group;
    }

    public final String usageAccountId() {
        return this.usageAccountId;
    }

    public final boolean hasQuantities() {
        return this.quantities != null && !(this.quantities instanceof SdkAutoConstructList);
    }

    public final List<UsageQuantity> quantities() {
        return this.quantities;
    }

    public final HistoricalUsageEntity historicalUsage() {
        return this.historicalUsage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuantities() ? this.quantities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.historicalUsage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillScenarioUsageModificationItem)) {
            return false;
        }
        BillScenarioUsageModificationItem other = (BillScenarioUsageModificationItem)obj;
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.usageType(), other.usageType()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.usageAccountId(), other.usageAccountId()) && this.hasQuantities() == other.hasQuantities() && Objects.equals(this.quantities(), other.quantities()) && Objects.equals(this.historicalUsage(), other.historicalUsage());
    }

    public final String toString() {
        return ToString.builder((String)"BillScenarioUsageModificationItem").add("ServiceCode", (Object)this.serviceCode()).add("UsageType", (Object)this.usageType()).add("Operation", (Object)this.operation()).add("Location", (Object)this.location()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Id", (Object)this.id()).add("Group", (Object)this.group()).add("UsageAccountId", (Object)this.usageAccountId()).add("Quantities", this.hasQuantities() ? this.quantities() : null).add("HistoricalUsage", (Object)this.historicalUsage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "usageAccountId": {
                return Optional.ofNullable(clazz.cast(this.usageAccountId()));
            }
            case "quantities": {
                return Optional.ofNullable(clazz.cast(this.quantities()));
            }
            case "historicalUsage": {
                return Optional.ofNullable(clazz.cast(this.historicalUsage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceCode", SERVICE_CODE_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("id", ID_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
        map.put("quantities", QUANTITIES_FIELD);
        map.put("historicalUsage", HISTORICAL_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillScenarioUsageModificationItem, T> g) {
        return obj -> g.apply((BillScenarioUsageModificationItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceCode;
        private String usageType;
        private String operation;
        private String location;
        private String availabilityZone;
        private String id;
        private String group;
        private String usageAccountId;
        private List<UsageQuantity> quantities = DefaultSdkAutoConstructList.getInstance();
        private HistoricalUsageEntity historicalUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(BillScenarioUsageModificationItem model) {
            this.serviceCode(model.serviceCode);
            this.usageType(model.usageType);
            this.operation(model.operation);
            this.location(model.location);
            this.availabilityZone(model.availabilityZone);
            this.id(model.id);
            this.group(model.group);
            this.usageAccountId(model.usageAccountId);
            this.quantities(model.quantities);
            this.historicalUsage(model.historicalUsage);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getUsageAccountId() {
            return this.usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final List<UsageQuantity.Builder> getQuantities() {
            List<UsageQuantity.Builder> result = UsageQuantitiesCopier.copyToBuilder(this.quantities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuantities(Collection<UsageQuantity.BuilderImpl> quantities) {
            this.quantities = UsageQuantitiesCopier.copyFromBuilder(quantities);
        }

        @Override
        public final Builder quantities(Collection<UsageQuantity> quantities) {
            this.quantities = UsageQuantitiesCopier.copy(quantities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quantities(UsageQuantity ... quantities) {
            this.quantities(Arrays.asList(quantities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quantities(Consumer<UsageQuantity.Builder> ... quantities) {
            this.quantities(Stream.of(quantities).map(c -> (UsageQuantity)((UsageQuantity.Builder)UsageQuantity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final HistoricalUsageEntity.Builder getHistoricalUsage() {
            return this.historicalUsage != null ? this.historicalUsage.toBuilder() : null;
        }

        public final void setHistoricalUsage(HistoricalUsageEntity.BuilderImpl historicalUsage) {
            this.historicalUsage = historicalUsage != null ? historicalUsage.build() : null;
        }

        @Override
        public final Builder historicalUsage(HistoricalUsageEntity historicalUsage) {
            this.historicalUsage = historicalUsage;
            return this;
        }

        public BillScenarioUsageModificationItem build() {
            return new BillScenarioUsageModificationItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillScenarioUsageModificationItem> {
        public Builder serviceCode(String var1);

        public Builder usageType(String var1);

        public Builder operation(String var1);

        public Builder location(String var1);

        public Builder availabilityZone(String var1);

        public Builder id(String var1);

        public Builder group(String var1);

        public Builder usageAccountId(String var1);

        public Builder quantities(Collection<UsageQuantity> var1);

        public Builder quantities(UsageQuantity ... var1);

        public Builder quantities(Consumer<UsageQuantity.Builder> ... var1);

        public Builder historicalUsage(HistoricalUsageEntity var1);

        default public Builder historicalUsage(Consumer<HistoricalUsageEntity.Builder> historicalUsage) {
            return this.historicalUsage((HistoricalUsageEntity)((HistoricalUsageEntity.Builder)HistoricalUsageEntity.builder().applyMutation(historicalUsage)).build());
        }
    }
}

