/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.FilterTimestamp;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosFilter;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBillScenariosRequest
extends BcmPricingCalculatorRequest
implements ToCopyableBuilder<Builder, ListBillScenariosRequest> {
    private static final SdkField<List<ListBillScenariosFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListBillScenariosRequest.getter(ListBillScenariosRequest::filters)).setter(ListBillScenariosRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListBillScenariosFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FilterTimestamp> CREATED_AT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("createdAtFilter").getter(ListBillScenariosRequest.getter(ListBillScenariosRequest::createdAtFilter)).setter(ListBillScenariosRequest.setter(Builder::createdAtFilter)).constructor(FilterTimestamp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAtFilter").build()}).build();
    private static final SdkField<FilterTimestamp> EXPIRES_AT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("expiresAtFilter").getter(ListBillScenariosRequest.getter(ListBillScenariosRequest::expiresAtFilter)).setter(ListBillScenariosRequest.setter(Builder::expiresAtFilter)).constructor(FilterTimestamp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAtFilter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBillScenariosRequest.getter(ListBillScenariosRequest::nextToken)).setter(ListBillScenariosRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListBillScenariosRequest.getter(ListBillScenariosRequest::maxResults)).setter(ListBillScenariosRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, CREATED_AT_FILTER_FIELD, EXPIRES_AT_FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBillScenariosRequest.memberNameToFieldInitializer();
    private final List<ListBillScenariosFilter> filters;
    private final FilterTimestamp createdAtFilter;
    private final FilterTimestamp expiresAtFilter;
    private final String nextToken;
    private final Integer maxResults;

    private ListBillScenariosRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.createdAtFilter = builder.createdAtFilter;
        this.expiresAtFilter = builder.expiresAtFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<ListBillScenariosFilter> filters() {
        return this.filters;
    }

    public final FilterTimestamp createdAtFilter() {
        return this.createdAtFilter;
    }

    public final FilterTimestamp expiresAtFilter() {
        return this.expiresAtFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAtFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAtFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillScenariosRequest)) {
            return false;
        }
        ListBillScenariosRequest other = (ListBillScenariosRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.createdAtFilter(), other.createdAtFilter()) && Objects.equals(this.expiresAtFilter(), other.expiresAtFilter()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListBillScenariosRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("CreatedAtFilter", (Object)this.createdAtFilter()).add("ExpiresAtFilter", (Object)this.expiresAtFilter()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "createdAtFilter": {
                return Optional.ofNullable(clazz.cast(this.createdAtFilter()));
            }
            case "expiresAtFilter": {
                return Optional.ofNullable(clazz.cast(this.expiresAtFilter()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filters", FILTERS_FIELD);
        map.put("createdAtFilter", CREATED_AT_FILTER_FIELD);
        map.put("expiresAtFilter", EXPIRES_AT_FILTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBillScenariosRequest, T> g) {
        return obj -> g.apply((ListBillScenariosRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorRequest.BuilderImpl
    implements Builder {
        private List<ListBillScenariosFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private FilterTimestamp createdAtFilter;
        private FilterTimestamp expiresAtFilter;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillScenariosRequest model) {
            super(model);
            this.filters(model.filters);
            this.createdAtFilter(model.createdAtFilter);
            this.expiresAtFilter(model.expiresAtFilter);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final List<ListBillScenariosFilter.Builder> getFilters() {
            List<ListBillScenariosFilter.Builder> result = ListBillScenariosFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ListBillScenariosFilter.BuilderImpl> filters) {
            this.filters = ListBillScenariosFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ListBillScenariosFilter> filters) {
            this.filters = ListBillScenariosFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ListBillScenariosFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ListBillScenariosFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ListBillScenariosFilter)((ListBillScenariosFilter.Builder)ListBillScenariosFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FilterTimestamp.Builder getCreatedAtFilter() {
            return this.createdAtFilter != null ? this.createdAtFilter.toBuilder() : null;
        }

        public final void setCreatedAtFilter(FilterTimestamp.BuilderImpl createdAtFilter) {
            this.createdAtFilter = createdAtFilter != null ? createdAtFilter.build() : null;
        }

        @Override
        public final Builder createdAtFilter(FilterTimestamp createdAtFilter) {
            this.createdAtFilter = createdAtFilter;
            return this;
        }

        public final FilterTimestamp.Builder getExpiresAtFilter() {
            return this.expiresAtFilter != null ? this.expiresAtFilter.toBuilder() : null;
        }

        public final void setExpiresAtFilter(FilterTimestamp.BuilderImpl expiresAtFilter) {
            this.expiresAtFilter = expiresAtFilter != null ? expiresAtFilter.build() : null;
        }

        @Override
        public final Builder expiresAtFilter(FilterTimestamp expiresAtFilter) {
            this.expiresAtFilter = expiresAtFilter;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBillScenariosRequest build() {
            return new ListBillScenariosRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BcmPricingCalculatorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBillScenariosRequest> {
        public Builder filters(Collection<ListBillScenariosFilter> var1);

        public Builder filters(ListBillScenariosFilter ... var1);

        public Builder filters(Consumer<ListBillScenariosFilter.Builder> ... var1);

        public Builder createdAtFilter(FilterTimestamp var1);

        default public Builder createdAtFilter(Consumer<FilterTimestamp.Builder> createdAtFilter) {
            return this.createdAtFilter((FilterTimestamp)((FilterTimestamp.Builder)FilterTimestamp.builder().applyMutation(createdAtFilter)).build());
        }

        public Builder expiresAtFilter(FilterTimestamp var1);

        default public Builder expiresAtFilter(Consumer<FilterTimestamp.Builder> expiresAtFilter) {
            return this.expiresAtFilter((FilterTimestamp)((FilterTimestamp.Builder)FilterTimestamp.builder().applyMutation(expiresAtFilter)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

