/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateCommitmentSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse;

public class ListBillEstimateCommitmentsIterable
implements SdkIterable<ListBillEstimateCommitmentsResponse> {
    private final BcmPricingCalculatorClient client;
    private final ListBillEstimateCommitmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBillEstimateCommitmentsIterable(BcmPricingCalculatorClient client, ListBillEstimateCommitmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBillEstimateCommitmentsResponseFetcher();
    }

    public Iterator<ListBillEstimateCommitmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BillEstimateCommitmentSummary> items() {
        Function<ListBillEstimateCommitmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBillEstimateCommitmentsResponseFetcher
    implements SyncPageFetcher<ListBillEstimateCommitmentsResponse> {
        private ListBillEstimateCommitmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillEstimateCommitmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBillEstimateCommitmentsResponse nextPage(ListBillEstimateCommitmentsResponse previousPage) {
            if (previousPage == null) {
                return ListBillEstimateCommitmentsIterable.this.client.listBillEstimateCommitments(ListBillEstimateCommitmentsIterable.this.firstRequest);
            }
            return ListBillEstimateCommitmentsIterable.this.client.listBillEstimateCommitments((ListBillEstimateCommitmentsRequest)((Object)ListBillEstimateCommitmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

