/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse;

public class ListBillEstimatesIterable
implements SdkIterable<ListBillEstimatesResponse> {
    private final BcmPricingCalculatorClient client;
    private final ListBillEstimatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBillEstimatesIterable(BcmPricingCalculatorClient client, ListBillEstimatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBillEstimatesResponseFetcher();
    }

    public Iterator<ListBillEstimatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BillEstimateSummary> items() {
        Function<ListBillEstimatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBillEstimatesResponseFetcher
    implements SyncPageFetcher<ListBillEstimatesResponse> {
        private ListBillEstimatesResponseFetcher() {
        }

        public boolean hasNextPage(ListBillEstimatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBillEstimatesResponse nextPage(ListBillEstimatesResponse previousPage) {
            if (previousPage == null) {
                return ListBillEstimatesIterable.this.client.listBillEstimates(ListBillEstimatesIterable.this.firstRequest);
            }
            return ListBillEstimatesIterable.this.client.listBillEstimates((ListBillEstimatesRequest)((Object)ListBillEstimatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

