/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.WorkloadEstimateUsageItem;

public class ListWorkloadEstimateUsageIterable
implements SdkIterable<ListWorkloadEstimateUsageResponse> {
    private final BcmPricingCalculatorClient client;
    private final ListWorkloadEstimateUsageRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkloadEstimateUsageIterable(BcmPricingCalculatorClient client, ListWorkloadEstimateUsageRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkloadEstimateUsageResponseFetcher();
    }

    public Iterator<ListWorkloadEstimateUsageResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkloadEstimateUsageItem> items() {
        Function<ListWorkloadEstimateUsageResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkloadEstimateUsageResponseFetcher
    implements SyncPageFetcher<ListWorkloadEstimateUsageResponse> {
        private ListWorkloadEstimateUsageResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadEstimateUsageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkloadEstimateUsageResponse nextPage(ListWorkloadEstimateUsageResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadEstimateUsageIterable.this.client.listWorkloadEstimateUsage(ListWorkloadEstimateUsageIterable.this.firstRequest);
            }
            return ListWorkloadEstimateUsageIterable.this.client.listWorkloadEstimateUsage((ListWorkloadEstimateUsageRequest)((Object)ListWorkloadEstimateUsageIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

