/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowNodeIODataType;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowNodeInputCategory;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputContent;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputExecutionChainCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputExecutionChainItem;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowTraceNodeInputField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowTraceNodeInputField> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(FlowTraceNodeInputField.getter(FlowTraceNodeInputField::categoryAsString)).setter(FlowTraceNodeInputField.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<FlowTraceNodeInputContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(FlowTraceNodeInputField.getter(FlowTraceNodeInputField::content)).setter(FlowTraceNodeInputField.setter(Builder::content)).constructor(FlowTraceNodeInputContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<List<FlowTraceNodeInputExecutionChainItem>> EXECUTION_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("executionChain").getter(FlowTraceNodeInputField.getter(FlowTraceNodeInputField::executionChain)).setter(FlowTraceNodeInputField.setter(Builder::executionChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionChain").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowTraceNodeInputExecutionChainItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NODE_INPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeInputName").getter(FlowTraceNodeInputField.getter(FlowTraceNodeInputField::nodeInputName)).setter(FlowTraceNodeInputField.setter(Builder::nodeInputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInputName").build()}).build();
    private static final SdkField<FlowTraceNodeInputSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(FlowTraceNodeInputField.getter(FlowTraceNodeInputField::source)).setter(FlowTraceNodeInputField.setter(Builder::source)).constructor(FlowTraceNodeInputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FlowTraceNodeInputField.getter(FlowTraceNodeInputField::typeAsString)).setter(FlowTraceNodeInputField.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, CONTENT_FIELD, EXECUTION_CHAIN_FIELD, NODE_INPUT_NAME_FIELD, SOURCE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowTraceNodeInputField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String category;
    private final FlowTraceNodeInputContent content;
    private final List<FlowTraceNodeInputExecutionChainItem> executionChain;
    private final String nodeInputName;
    private final FlowTraceNodeInputSource source;
    private final String type;

    private FlowTraceNodeInputField(BuilderImpl builder) {
        this.category = builder.category;
        this.content = builder.content;
        this.executionChain = builder.executionChain;
        this.nodeInputName = builder.nodeInputName;
        this.source = builder.source;
        this.type = builder.type;
    }

    public final FlowNodeInputCategory category() {
        return FlowNodeInputCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final FlowTraceNodeInputContent content() {
        return this.content;
    }

    public final boolean hasExecutionChain() {
        return this.executionChain != null && !(this.executionChain instanceof SdkAutoConstructList);
    }

    public final List<FlowTraceNodeInputExecutionChainItem> executionChain() {
        return this.executionChain;
    }

    public final String nodeInputName() {
        return this.nodeInputName;
    }

    public final FlowTraceNodeInputSource source() {
        return this.source;
    }

    public final FlowNodeIODataType type() {
        return FlowNodeIODataType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionChain() ? this.executionChain() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeInputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeInputField)) {
            return false;
        }
        FlowTraceNodeInputField other = (FlowTraceNodeInputField)obj;
        return Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.content(), other.content()) && this.hasExecutionChain() == other.hasExecutionChain() && Objects.equals(this.executionChain(), other.executionChain()) && Objects.equals(this.nodeInputName(), other.nodeInputName()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FlowTraceNodeInputField").add("Category", (Object)this.categoryAsString()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("ExecutionChain", (Object)(this.executionChain() == null ? null : "*** Sensitive Data Redacted ***")).add("NodeInputName", (Object)this.nodeInputName()).add("Source", (Object)(this.source() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "executionChain": {
                return Optional.ofNullable(clazz.cast(this.executionChain()));
            }
            case "nodeInputName": {
                return Optional.ofNullable(clazz.cast(this.nodeInputName()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("category", CATEGORY_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("executionChain", EXECUTION_CHAIN_FIELD);
        map.put("nodeInputName", NODE_INPUT_NAME_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeInputField, T> g) {
        return obj -> g.apply((FlowTraceNodeInputField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private FlowTraceNodeInputContent content;
        private List<FlowTraceNodeInputExecutionChainItem> executionChain = DefaultSdkAutoConstructList.getInstance();
        private String nodeInputName;
        private FlowTraceNodeInputSource source;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeInputField model) {
            this.category(model.category);
            this.content(model.content);
            this.executionChain(model.executionChain);
            this.nodeInputName(model.nodeInputName);
            this.source(model.source);
            this.type(model.type);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(FlowNodeInputCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final FlowTraceNodeInputContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(FlowTraceNodeInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowTraceNodeInputContent content) {
            this.content = content;
            return this;
        }

        public final List<FlowTraceNodeInputExecutionChainItem.Builder> getExecutionChain() {
            List<FlowTraceNodeInputExecutionChainItem.Builder> result = FlowTraceNodeInputExecutionChainCopier.copyToBuilder(this.executionChain);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutionChain(Collection<FlowTraceNodeInputExecutionChainItem.BuilderImpl> executionChain) {
            this.executionChain = FlowTraceNodeInputExecutionChainCopier.copyFromBuilder(executionChain);
        }

        @Override
        public final Builder executionChain(Collection<FlowTraceNodeInputExecutionChainItem> executionChain) {
            this.executionChain = FlowTraceNodeInputExecutionChainCopier.copy(executionChain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionChain(FlowTraceNodeInputExecutionChainItem ... executionChain) {
            this.executionChain(Arrays.asList(executionChain));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionChain(Consumer<FlowTraceNodeInputExecutionChainItem.Builder> ... executionChain) {
            this.executionChain(Stream.of(executionChain).map(c -> (FlowTraceNodeInputExecutionChainItem)((FlowTraceNodeInputExecutionChainItem.Builder)FlowTraceNodeInputExecutionChainItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNodeInputName() {
            return this.nodeInputName;
        }

        public final void setNodeInputName(String nodeInputName) {
            this.nodeInputName = nodeInputName;
        }

        @Override
        public final Builder nodeInputName(String nodeInputName) {
            this.nodeInputName = nodeInputName;
            return this;
        }

        public final FlowTraceNodeInputSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(FlowTraceNodeInputSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(FlowTraceNodeInputSource source) {
            this.source = source;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowNodeIODataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public FlowTraceNodeInputField build() {
            return new FlowTraceNodeInputField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowTraceNodeInputField> {
        public Builder category(String var1);

        public Builder category(FlowNodeInputCategory var1);

        public Builder content(FlowTraceNodeInputContent var1);

        default public Builder content(Consumer<FlowTraceNodeInputContent.Builder> content) {
            return this.content((FlowTraceNodeInputContent)((FlowTraceNodeInputContent.Builder)FlowTraceNodeInputContent.builder().applyMutation(content)).build());
        }

        public Builder executionChain(Collection<FlowTraceNodeInputExecutionChainItem> var1);

        public Builder executionChain(FlowTraceNodeInputExecutionChainItem ... var1);

        public Builder executionChain(Consumer<FlowTraceNodeInputExecutionChainItem.Builder> ... var1);

        public Builder nodeInputName(String var1);

        public Builder source(FlowTraceNodeInputSource var1);

        default public Builder source(Consumer<FlowTraceNodeInputSource.Builder> source) {
            return this.source((FlowTraceNodeInputSource)((FlowTraceNodeInputSource.Builder)FlowTraceNodeInputSource.builder().applyMutation(source)).build());
        }

        public Builder type(String var1);

        public Builder type(FlowNodeIODataType var1);
    }
}

