/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.AudioSegment;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultContentColumn;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultContentRowCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultContentType;
import software.amazon.awssdk.services.bedrockagentruntime.model.VideoSegment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrievalResultContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrievalResultContent> {
    private static final SdkField<AudioSegment> AUDIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audio").getter(RetrievalResultContent.getter(RetrievalResultContent::audio)).setter(RetrievalResultContent.setter(Builder::audio)).constructor(AudioSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build()}).build();
    private static final SdkField<String> BYTE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("byteContent").getter(RetrievalResultContent.getter(RetrievalResultContent::byteContent)).setter(RetrievalResultContent.setter(Builder::byteContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteContent").build()}).build();
    private static final SdkField<List<RetrievalResultContentColumn>> ROW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("row").getter(RetrievalResultContent.getter(RetrievalResultContent::row)).setter(RetrievalResultContent.setter(Builder::row)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("row").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RetrievalResultContentColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(RetrievalResultContent.getter(RetrievalResultContent::text)).setter(RetrievalResultContent.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RetrievalResultContent.getter(RetrievalResultContent::typeAsString)).setter(RetrievalResultContent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<VideoSegment> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("video").getter(RetrievalResultContent.getter(RetrievalResultContent::video)).setter(RetrievalResultContent.setter(Builder::video)).constructor(VideoSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FIELD, BYTE_CONTENT_FIELD, ROW_FIELD, TEXT_FIELD, TYPE_FIELD, VIDEO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrievalResultContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AudioSegment audio;
    private final String byteContent;
    private final List<RetrievalResultContentColumn> row;
    private final String text;
    private final String type;
    private final VideoSegment video;

    private RetrievalResultContent(BuilderImpl builder) {
        this.audio = builder.audio;
        this.byteContent = builder.byteContent;
        this.row = builder.row;
        this.text = builder.text;
        this.type = builder.type;
        this.video = builder.video;
    }

    public final AudioSegment audio() {
        return this.audio;
    }

    public final String byteContent() {
        return this.byteContent;
    }

    public final boolean hasRow() {
        return this.row != null && !(this.row instanceof SdkAutoConstructList);
    }

    public final List<RetrievalResultContentColumn> row() {
        return this.row;
    }

    public final String text() {
        return this.text;
    }

    public final RetrievalResultContentType type() {
        return RetrievalResultContentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final VideoSegment video() {
        return this.video;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audio());
        hashCode = 31 * hashCode + Objects.hashCode(this.byteContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRow() ? this.row() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalResultContent)) {
            return false;
        }
        RetrievalResultContent other = (RetrievalResultContent)obj;
        return Objects.equals(this.audio(), other.audio()) && Objects.equals(this.byteContent(), other.byteContent()) && this.hasRow() == other.hasRow() && Objects.equals(this.row(), other.row()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.video(), other.video());
    }

    public final String toString() {
        return ToString.builder((String)"RetrievalResultContent").add("Audio", (Object)this.audio()).add("ByteContent", (Object)this.byteContent()).add("Row", (Object)(this.row() == null ? null : "*** Sensitive Data Redacted ***")).add("Text", (Object)this.text()).add("Type", (Object)this.typeAsString()).add("Video", (Object)this.video()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "audio": {
                return Optional.ofNullable(clazz.cast(this.audio()));
            }
            case "byteContent": {
                return Optional.ofNullable(clazz.cast(this.byteContent()));
            }
            case "row": {
                return Optional.ofNullable(clazz.cast(this.row()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("audio", AUDIO_FIELD);
        map.put("byteContent", BYTE_CONTENT_FIELD);
        map.put("row", ROW_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("video", VIDEO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievalResultContent, T> g) {
        return obj -> g.apply((RetrievalResultContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioSegment audio;
        private String byteContent;
        private List<RetrievalResultContentColumn> row = DefaultSdkAutoConstructList.getInstance();
        private String text;
        private String type;
        private VideoSegment video;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalResultContent model) {
            this.audio(model.audio);
            this.byteContent(model.byteContent);
            this.row(model.row);
            this.text(model.text);
            this.type(model.type);
            this.video(model.video);
        }

        public final AudioSegment.Builder getAudio() {
            return this.audio != null ? this.audio.toBuilder() : null;
        }

        public final void setAudio(AudioSegment.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioSegment audio) {
            this.audio = audio;
            return this;
        }

        public final String getByteContent() {
            return this.byteContent;
        }

        public final void setByteContent(String byteContent) {
            this.byteContent = byteContent;
        }

        @Override
        public final Builder byteContent(String byteContent) {
            this.byteContent = byteContent;
            return this;
        }

        public final List<RetrievalResultContentColumn.Builder> getRow() {
            List<RetrievalResultContentColumn.Builder> result = RetrievalResultContentRowCopier.copyToBuilder(this.row);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRow(Collection<RetrievalResultContentColumn.BuilderImpl> row) {
            this.row = RetrievalResultContentRowCopier.copyFromBuilder(row);
        }

        @Override
        public final Builder row(Collection<RetrievalResultContentColumn> row) {
            this.row = RetrievalResultContentRowCopier.copy(row);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder row(RetrievalResultContentColumn ... row) {
            this.row(Arrays.asList(row));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder row(Consumer<RetrievalResultContentColumn.Builder> ... row) {
            this.row(Stream.of(row).map(c -> (RetrievalResultContentColumn)((RetrievalResultContentColumn.Builder)RetrievalResultContentColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrievalResultContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final VideoSegment.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(VideoSegment.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoSegment video) {
            this.video = video;
            return this;
        }

        public RetrievalResultContent build() {
            return new RetrievalResultContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrievalResultContent> {
        public Builder audio(AudioSegment var1);

        default public Builder audio(Consumer<AudioSegment.Builder> audio) {
            return this.audio((AudioSegment)((AudioSegment.Builder)AudioSegment.builder().applyMutation(audio)).build());
        }

        public Builder byteContent(String var1);

        public Builder row(Collection<RetrievalResultContentColumn> var1);

        public Builder row(RetrievalResultContentColumn ... var1);

        public Builder row(Consumer<RetrievalResultContentColumn.Builder> ... var1);

        public Builder text(String var1);

        public Builder type(String var1);

        public Builder type(RetrievalResultContentType var1);

        public Builder video(VideoSegment var1);

        default public Builder video(Consumer<VideoSegment.Builder> video) {
            return this.video((VideoSegment)((VideoSegment.Builder)VideoSegment.builder().applyMutation(video)).build());
        }
    }
}

