/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlueprintFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlueprintFilter> {
    private static final SdkField<String> BLUEPRINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintArn").getter(BlueprintFilter.getter(BlueprintFilter::blueprintArn)).setter(BlueprintFilter.setter(Builder::blueprintArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintArn").build()}).build();
    private static final SdkField<String> BLUEPRINT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintVersion").getter(BlueprintFilter.getter(BlueprintFilter::blueprintVersion)).setter(BlueprintFilter.setter(Builder::blueprintVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintVersion").build()}).build();
    private static final SdkField<String> BLUEPRINT_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintStage").getter(BlueprintFilter.getter(BlueprintFilter::blueprintStageAsString)).setter(BlueprintFilter.setter(Builder::blueprintStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintStage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ARN_FIELD, BLUEPRINT_VERSION_FIELD, BLUEPRINT_STAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BlueprintFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String blueprintArn;
    private final String blueprintVersion;
    private final String blueprintStage;

    private BlueprintFilter(BuilderImpl builder) {
        this.blueprintArn = builder.blueprintArn;
        this.blueprintVersion = builder.blueprintVersion;
        this.blueprintStage = builder.blueprintStage;
    }

    public final String blueprintArn() {
        return this.blueprintArn;
    }

    public final String blueprintVersion() {
        return this.blueprintVersion;
    }

    public final BlueprintStage blueprintStage() {
        return BlueprintStage.fromValue(this.blueprintStage);
    }

    public final String blueprintStageAsString() {
        return this.blueprintStage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintStageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueprintFilter)) {
            return false;
        }
        BlueprintFilter other = (BlueprintFilter)obj;
        return Objects.equals(this.blueprintArn(), other.blueprintArn()) && Objects.equals(this.blueprintVersion(), other.blueprintVersion()) && Objects.equals(this.blueprintStageAsString(), other.blueprintStageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BlueprintFilter").add("BlueprintArn", (Object)this.blueprintArn()).add("BlueprintVersion", (Object)this.blueprintVersion()).add("BlueprintStage", (Object)this.blueprintStageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprintArn": {
                return Optional.ofNullable(clazz.cast(this.blueprintArn()));
            }
            case "blueprintVersion": {
                return Optional.ofNullable(clazz.cast(this.blueprintVersion()));
            }
            case "blueprintStage": {
                return Optional.ofNullable(clazz.cast(this.blueprintStageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("blueprintArn", BLUEPRINT_ARN_FIELD);
        map.put("blueprintVersion", BLUEPRINT_VERSION_FIELD);
        map.put("blueprintStage", BLUEPRINT_STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlueprintFilter, T> g) {
        return obj -> g.apply((BlueprintFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blueprintArn;
        private String blueprintVersion;
        private String blueprintStage;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueprintFilter model) {
            this.blueprintArn(model.blueprintArn);
            this.blueprintVersion(model.blueprintVersion);
            this.blueprintStage(model.blueprintStage);
        }

        public final String getBlueprintArn() {
            return this.blueprintArn;
        }

        public final void setBlueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
        }

        @Override
        public final Builder blueprintArn(String blueprintArn) {
            this.blueprintArn = blueprintArn;
            return this;
        }

        public final String getBlueprintVersion() {
            return this.blueprintVersion;
        }

        public final void setBlueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
        }

        @Override
        public final Builder blueprintVersion(String blueprintVersion) {
            this.blueprintVersion = blueprintVersion;
            return this;
        }

        public final String getBlueprintStage() {
            return this.blueprintStage;
        }

        public final void setBlueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
        }

        @Override
        public final Builder blueprintStage(String blueprintStage) {
            this.blueprintStage = blueprintStage;
            return this;
        }

        @Override
        public final Builder blueprintStage(BlueprintStage blueprintStage) {
            this.blueprintStage(blueprintStage == null ? null : blueprintStage.toString());
            return this;
        }

        public BlueprintFilter build() {
            return new BlueprintFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlueprintFilter> {
        public Builder blueprintArn(String var1);

        public Builder blueprintVersion(String var1);

        public Builder blueprintStage(String var1);

        public Builder blueprintStage(BlueprintStage var1);
    }
}

