/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BlueprintStage {
    DEVELOPMENT("DEVELOPMENT"),
    LIVE("LIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BlueprintStage> VALUE_MAP;
    private final String value;

    private BlueprintStage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlueprintStage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlueprintStage> knownValues() {
        EnumSet<BlueprintStage> knownValues = EnumSet.allOf(BlueprintStage.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BlueprintStage.class, BlueprintStage::toString);
    }
}

