/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BlueprintStageFilter {
    DEVELOPMENT("DEVELOPMENT"),
    LIVE("LIVE"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BlueprintStageFilter> VALUE_MAP;
    private final String value;

    private BlueprintStageFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlueprintStageFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlueprintStageFilter> knownValues() {
        EnumSet<BlueprintStageFilter> knownValues = EnumSet.allOf(BlueprintStageFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BlueprintStageFilter.class, BlueprintStageFilter::toString);
    }
}

