/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockdataautomation.model.PIIEntityType;
import software.amazon.awssdk.services.bedrockdataautomation.model.PIIEntityTypesCopier;
import software.amazon.awssdk.services.bedrockdataautomation.model.PIIRedactionMaskMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PIIEntitiesConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PIIEntitiesConfiguration> {
    private static final SdkField<List<String>> PII_ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("piiEntityTypes").getter(PIIEntitiesConfiguration.getter(PIIEntitiesConfiguration::piiEntityTypesAsStrings)).setter(PIIEntitiesConfiguration.setter(Builder::piiEntityTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("piiEntityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REDACTION_MASK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("redactionMaskMode").getter(PIIEntitiesConfiguration.getter(PIIEntitiesConfiguration::redactionMaskModeAsString)).setter(PIIEntitiesConfiguration.setter(Builder::redactionMaskMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redactionMaskMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PII_ENTITY_TYPES_FIELD, REDACTION_MASK_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PIIEntitiesConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> piiEntityTypes;
    private final String redactionMaskMode;

    private PIIEntitiesConfiguration(BuilderImpl builder) {
        this.piiEntityTypes = builder.piiEntityTypes;
        this.redactionMaskMode = builder.redactionMaskMode;
    }

    public final List<PIIEntityType> piiEntityTypes() {
        return PIIEntityTypesCopier.copyStringToEnum(this.piiEntityTypes);
    }

    public final boolean hasPiiEntityTypes() {
        return this.piiEntityTypes != null && !(this.piiEntityTypes instanceof SdkAutoConstructList);
    }

    public final List<String> piiEntityTypesAsStrings() {
        return this.piiEntityTypes;
    }

    public final PIIRedactionMaskMode redactionMaskMode() {
        return PIIRedactionMaskMode.fromValue(this.redactionMaskMode);
    }

    public final String redactionMaskModeAsString() {
        return this.redactionMaskMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPiiEntityTypes() ? this.piiEntityTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.redactionMaskModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PIIEntitiesConfiguration)) {
            return false;
        }
        PIIEntitiesConfiguration other = (PIIEntitiesConfiguration)obj;
        return this.hasPiiEntityTypes() == other.hasPiiEntityTypes() && Objects.equals(this.piiEntityTypesAsStrings(), other.piiEntityTypesAsStrings()) && Objects.equals(this.redactionMaskModeAsString(), other.redactionMaskModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PIIEntitiesConfiguration").add("PiiEntityTypes", this.hasPiiEntityTypes() ? this.piiEntityTypesAsStrings() : null).add("RedactionMaskMode", (Object)this.redactionMaskModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "piiEntityTypes": {
                return Optional.ofNullable(clazz.cast(this.piiEntityTypesAsStrings()));
            }
            case "redactionMaskMode": {
                return Optional.ofNullable(clazz.cast(this.redactionMaskModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("piiEntityTypes", PII_ENTITY_TYPES_FIELD);
        map.put("redactionMaskMode", REDACTION_MASK_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PIIEntitiesConfiguration, T> g) {
        return obj -> g.apply((PIIEntitiesConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> piiEntityTypes = DefaultSdkAutoConstructList.getInstance();
        private String redactionMaskMode;

        private BuilderImpl() {
        }

        private BuilderImpl(PIIEntitiesConfiguration model) {
            this.piiEntityTypesWithStrings(model.piiEntityTypes);
            this.redactionMaskMode(model.redactionMaskMode);
        }

        public final Collection<String> getPiiEntityTypes() {
            if (this.piiEntityTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.piiEntityTypes;
        }

        public final void setPiiEntityTypes(Collection<String> piiEntityTypes) {
            this.piiEntityTypes = PIIEntityTypesCopier.copy(piiEntityTypes);
        }

        @Override
        public final Builder piiEntityTypesWithStrings(Collection<String> piiEntityTypes) {
            this.piiEntityTypes = PIIEntityTypesCopier.copy(piiEntityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntityTypesWithStrings(String ... piiEntityTypes) {
            this.piiEntityTypesWithStrings(Arrays.asList(piiEntityTypes));
            return this;
        }

        @Override
        public final Builder piiEntityTypes(Collection<PIIEntityType> piiEntityTypes) {
            this.piiEntityTypes = PIIEntityTypesCopier.copyEnumToString(piiEntityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntityTypes(PIIEntityType ... piiEntityTypes) {
            this.piiEntityTypes(Arrays.asList(piiEntityTypes));
            return this;
        }

        public final String getRedactionMaskMode() {
            return this.redactionMaskMode;
        }

        public final void setRedactionMaskMode(String redactionMaskMode) {
            this.redactionMaskMode = redactionMaskMode;
        }

        @Override
        public final Builder redactionMaskMode(String redactionMaskMode) {
            this.redactionMaskMode = redactionMaskMode;
            return this;
        }

        @Override
        public final Builder redactionMaskMode(PIIRedactionMaskMode redactionMaskMode) {
            this.redactionMaskMode(redactionMaskMode == null ? null : redactionMaskMode.toString());
            return this;
        }

        public PIIEntitiesConfiguration build() {
            return new PIIEntitiesConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PIIEntitiesConfiguration> {
        public Builder piiEntityTypesWithStrings(Collection<String> var1);

        public Builder piiEntityTypesWithStrings(String ... var1);

        public Builder piiEntityTypes(Collection<PIIEntityType> var1);

        public Builder piiEntityTypes(PIIEntityType ... var1);

        public Builder redactionMaskMode(String var1);

        public Builder redactionMaskMode(PIIRedactionMaskMode var1);
    }
}

