/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.BedrockDataAutomationRuntimeRequest;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.Blueprint;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.BlueprintListCopier;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.DataAutomationConfiguration;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.EncryptionConfiguration;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.SyncInputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeDataAutomationRequest
extends BedrockDataAutomationRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeDataAutomationRequest> {
    private static final SdkField<SyncInputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputConfiguration").getter(InvokeDataAutomationRequest.getter(InvokeDataAutomationRequest::inputConfiguration)).setter(InvokeDataAutomationRequest.setter(Builder::inputConfiguration)).constructor(SyncInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build()}).build();
    private static final SdkField<DataAutomationConfiguration> DATA_AUTOMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataAutomationConfiguration").getter(InvokeDataAutomationRequest.getter(InvokeDataAutomationRequest::dataAutomationConfiguration)).setter(InvokeDataAutomationRequest.setter(Builder::dataAutomationConfiguration)).constructor(DataAutomationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAutomationConfiguration").build()}).build();
    private static final SdkField<List<Blueprint>> BLUEPRINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blueprints").getter(InvokeDataAutomationRequest.getter(InvokeDataAutomationRequest::blueprints)).setter(InvokeDataAutomationRequest.setter(Builder::blueprints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Blueprint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_AUTOMATION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAutomationProfileArn").getter(InvokeDataAutomationRequest.getter(InvokeDataAutomationRequest::dataAutomationProfileArn)).setter(InvokeDataAutomationRequest.setter(Builder::dataAutomationProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAutomationProfileArn").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(InvokeDataAutomationRequest.getter(InvokeDataAutomationRequest::encryptionConfiguration)).setter(InvokeDataAutomationRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_CONFIGURATION_FIELD, DATA_AUTOMATION_CONFIGURATION_FIELD, BLUEPRINTS_FIELD, DATA_AUTOMATION_PROFILE_ARN_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeDataAutomationRequest.memberNameToFieldInitializer();
    private final SyncInputConfiguration inputConfiguration;
    private final DataAutomationConfiguration dataAutomationConfiguration;
    private final List<Blueprint> blueprints;
    private final String dataAutomationProfileArn;
    private final EncryptionConfiguration encryptionConfiguration;

    private InvokeDataAutomationRequest(BuilderImpl builder) {
        super(builder);
        this.inputConfiguration = builder.inputConfiguration;
        this.dataAutomationConfiguration = builder.dataAutomationConfiguration;
        this.blueprints = builder.blueprints;
        this.dataAutomationProfileArn = builder.dataAutomationProfileArn;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final SyncInputConfiguration inputConfiguration() {
        return this.inputConfiguration;
    }

    public final DataAutomationConfiguration dataAutomationConfiguration() {
        return this.dataAutomationConfiguration;
    }

    public final boolean hasBlueprints() {
        return this.blueprints != null && !(this.blueprints instanceof SdkAutoConstructList);
    }

    public final List<Blueprint> blueprints() {
        return this.blueprints;
    }

    public final String dataAutomationProfileArn() {
        return this.dataAutomationProfileArn;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAutomationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlueprints() ? this.blueprints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAutomationProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeDataAutomationRequest)) {
            return false;
        }
        InvokeDataAutomationRequest other = (InvokeDataAutomationRequest)((Object)obj);
        return Objects.equals(this.inputConfiguration(), other.inputConfiguration()) && Objects.equals(this.dataAutomationConfiguration(), other.dataAutomationConfiguration()) && this.hasBlueprints() == other.hasBlueprints() && Objects.equals(this.blueprints(), other.blueprints()) && Objects.equals(this.dataAutomationProfileArn(), other.dataAutomationProfileArn()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeDataAutomationRequest").add("InputConfiguration", (Object)this.inputConfiguration()).add("DataAutomationConfiguration", (Object)this.dataAutomationConfiguration()).add("Blueprints", this.hasBlueprints() ? this.blueprints() : null).add("DataAutomationProfileArn", (Object)this.dataAutomationProfileArn()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputConfiguration()));
            }
            case "dataAutomationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataAutomationConfiguration()));
            }
            case "blueprints": {
                return Optional.ofNullable(clazz.cast(this.blueprints()));
            }
            case "dataAutomationProfileArn": {
                return Optional.ofNullable(clazz.cast(this.dataAutomationProfileArn()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputConfiguration", INPUT_CONFIGURATION_FIELD);
        map.put("dataAutomationConfiguration", DATA_AUTOMATION_CONFIGURATION_FIELD);
        map.put("blueprints", BLUEPRINTS_FIELD);
        map.put("dataAutomationProfileArn", DATA_AUTOMATION_PROFILE_ARN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeDataAutomationRequest, T> g) {
        return obj -> g.apply((InvokeDataAutomationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationRuntimeRequest.BuilderImpl
    implements Builder {
        private SyncInputConfiguration inputConfiguration;
        private DataAutomationConfiguration dataAutomationConfiguration;
        private List<Blueprint> blueprints = DefaultSdkAutoConstructList.getInstance();
        private String dataAutomationProfileArn;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeDataAutomationRequest model) {
            super(model);
            this.inputConfiguration(model.inputConfiguration);
            this.dataAutomationConfiguration(model.dataAutomationConfiguration);
            this.blueprints(model.blueprints);
            this.dataAutomationProfileArn(model.dataAutomationProfileArn);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final SyncInputConfiguration.Builder getInputConfiguration() {
            return this.inputConfiguration != null ? this.inputConfiguration.toBuilder() : null;
        }

        public final void setInputConfiguration(SyncInputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        @Override
        public final Builder inputConfiguration(SyncInputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final DataAutomationConfiguration.Builder getDataAutomationConfiguration() {
            return this.dataAutomationConfiguration != null ? this.dataAutomationConfiguration.toBuilder() : null;
        }

        public final void setDataAutomationConfiguration(DataAutomationConfiguration.BuilderImpl dataAutomationConfiguration) {
            this.dataAutomationConfiguration = dataAutomationConfiguration != null ? dataAutomationConfiguration.build() : null;
        }

        @Override
        public final Builder dataAutomationConfiguration(DataAutomationConfiguration dataAutomationConfiguration) {
            this.dataAutomationConfiguration = dataAutomationConfiguration;
            return this;
        }

        public final List<Blueprint.Builder> getBlueprints() {
            List<Blueprint.Builder> result = BlueprintListCopier.copyToBuilder(this.blueprints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprints(Collection<Blueprint.BuilderImpl> blueprints) {
            this.blueprints = BlueprintListCopier.copyFromBuilder(blueprints);
        }

        @Override
        public final Builder blueprints(Collection<Blueprint> blueprints) {
            this.blueprints = BlueprintListCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Blueprint ... blueprints) {
            this.blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<Blueprint.Builder> ... blueprints) {
            this.blueprints(Stream.of(blueprints).map(c -> (Blueprint)((Blueprint.Builder)Blueprint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataAutomationProfileArn() {
            return this.dataAutomationProfileArn;
        }

        public final void setDataAutomationProfileArn(String dataAutomationProfileArn) {
            this.dataAutomationProfileArn = dataAutomationProfileArn;
        }

        @Override
        public final Builder dataAutomationProfileArn(String dataAutomationProfileArn) {
            this.dataAutomationProfileArn = dataAutomationProfileArn;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeDataAutomationRequest build() {
            return new InvokeDataAutomationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockDataAutomationRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeDataAutomationRequest> {
        public Builder inputConfiguration(SyncInputConfiguration var1);

        default public Builder inputConfiguration(Consumer<SyncInputConfiguration.Builder> inputConfiguration) {
            return this.inputConfiguration((SyncInputConfiguration)((SyncInputConfiguration.Builder)SyncInputConfiguration.builder().applyMutation(inputConfiguration)).build());
        }

        public Builder dataAutomationConfiguration(DataAutomationConfiguration var1);

        default public Builder dataAutomationConfiguration(Consumer<DataAutomationConfiguration.Builder> dataAutomationConfiguration) {
            return this.dataAutomationConfiguration((DataAutomationConfiguration)((DataAutomationConfiguration.Builder)DataAutomationConfiguration.builder().applyMutation(dataAutomationConfiguration)).build());
        }

        public Builder blueprints(Collection<Blueprint> var1);

        public Builder blueprints(Blueprint ... var1);

        public Builder blueprints(Consumer<Blueprint.Builder> ... var1);

        public Builder dataAutomationProfileArn(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

