/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AudioFormat {
    MP3("mp3"),
    OPUS("opus"),
    WAV("wav"),
    AAC("aac"),
    FLAC("flac"),
    MP4("mp4"),
    OGG("ogg"),
    MKV("mkv"),
    MKA("mka"),
    X_AAC("x-aac"),
    M4_A("m4a"),
    MPEG("mpeg"),
    MPGA("mpga"),
    PCM("pcm"),
    WEBM("webm"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioFormat> VALUE_MAP;
    private final String value;

    private AudioFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioFormat> knownValues() {
        EnumSet<AudioFormat> knownValues = EnumSet.allOf(AudioFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AudioFormat.class, AudioFormat::toString);
    }
}

