/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentCharLocation;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentChunkLocation;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentPageLocation;
import software.amazon.awssdk.services.bedrockruntime.model.SearchResultLocation;
import software.amazon.awssdk.services.bedrockruntime.model.WebLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CitationLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CitationLocation> {
    private static final SdkField<WebLocation> WEB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("web").getter(CitationLocation.getter(CitationLocation::web)).setter(CitationLocation.setter(Builder::web)).constructor(WebLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("web").build()}).build();
    private static final SdkField<DocumentCharLocation> DOCUMENT_CHAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentChar").getter(CitationLocation.getter(CitationLocation::documentChar)).setter(CitationLocation.setter(Builder::documentChar)).constructor(DocumentCharLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentChar").build()}).build();
    private static final SdkField<DocumentPageLocation> DOCUMENT_PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentPage").getter(CitationLocation.getter(CitationLocation::documentPage)).setter(CitationLocation.setter(Builder::documentPage)).constructor(DocumentPageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentPage").build()}).build();
    private static final SdkField<DocumentChunkLocation> DOCUMENT_CHUNK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentChunk").getter(CitationLocation.getter(CitationLocation::documentChunk)).setter(CitationLocation.setter(Builder::documentChunk)).constructor(DocumentChunkLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentChunk").build()}).build();
    private static final SdkField<SearchResultLocation> SEARCH_RESULT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("searchResultLocation").getter(CitationLocation.getter(CitationLocation::searchResultLocation)).setter(CitationLocation.setter(Builder::searchResultLocation)).constructor(SearchResultLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchResultLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_FIELD, DOCUMENT_CHAR_FIELD, DOCUMENT_PAGE_FIELD, DOCUMENT_CHUNK_FIELD, SEARCH_RESULT_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CitationLocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final WebLocation web;
    private final DocumentCharLocation documentChar;
    private final DocumentPageLocation documentPage;
    private final DocumentChunkLocation documentChunk;
    private final SearchResultLocation searchResultLocation;
    private final Type type;

    private CitationLocation(BuilderImpl builder) {
        this.web = builder.web;
        this.documentChar = builder.documentChar;
        this.documentPage = builder.documentPage;
        this.documentChunk = builder.documentChunk;
        this.searchResultLocation = builder.searchResultLocation;
        this.type = builder.type;
    }

    public final WebLocation web() {
        return this.web;
    }

    public final DocumentCharLocation documentChar() {
        return this.documentChar;
    }

    public final DocumentPageLocation documentPage() {
        return this.documentPage;
    }

    public final DocumentChunkLocation documentChunk() {
        return this.documentChunk;
    }

    public final SearchResultLocation searchResultLocation() {
        return this.searchResultLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.web());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentChar());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentPage());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentChunk());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchResultLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CitationLocation)) {
            return false;
        }
        CitationLocation other = (CitationLocation)obj;
        return Objects.equals(this.web(), other.web()) && Objects.equals(this.documentChar(), other.documentChar()) && Objects.equals(this.documentPage(), other.documentPage()) && Objects.equals(this.documentChunk(), other.documentChunk()) && Objects.equals(this.searchResultLocation(), other.searchResultLocation());
    }

    public final String toString() {
        return ToString.builder((String)"CitationLocation").add("Web", (Object)this.web()).add("DocumentChar", (Object)this.documentChar()).add("DocumentPage", (Object)this.documentPage()).add("DocumentChunk", (Object)this.documentChunk()).add("SearchResultLocation", (Object)this.searchResultLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "web": {
                return Optional.ofNullable(clazz.cast(this.web()));
            }
            case "documentChar": {
                return Optional.ofNullable(clazz.cast(this.documentChar()));
            }
            case "documentPage": {
                return Optional.ofNullable(clazz.cast(this.documentPage()));
            }
            case "documentChunk": {
                return Optional.ofNullable(clazz.cast(this.documentChunk()));
            }
            case "searchResultLocation": {
                return Optional.ofNullable(clazz.cast(this.searchResultLocation()));
            }
        }
        return Optional.empty();
    }

    public static CitationLocation fromWeb(WebLocation web) {
        return (CitationLocation)CitationLocation.builder().web(web).build();
    }

    public static CitationLocation fromWeb(Consumer<WebLocation.Builder> web) {
        WebLocation.Builder builder = WebLocation.builder();
        web.accept(builder);
        return CitationLocation.fromWeb((WebLocation)builder.build());
    }

    public static CitationLocation fromDocumentChar(DocumentCharLocation documentChar) {
        return (CitationLocation)CitationLocation.builder().documentChar(documentChar).build();
    }

    public static CitationLocation fromDocumentChar(Consumer<DocumentCharLocation.Builder> documentChar) {
        DocumentCharLocation.Builder builder = DocumentCharLocation.builder();
        documentChar.accept(builder);
        return CitationLocation.fromDocumentChar((DocumentCharLocation)builder.build());
    }

    public static CitationLocation fromDocumentPage(DocumentPageLocation documentPage) {
        return (CitationLocation)CitationLocation.builder().documentPage(documentPage).build();
    }

    public static CitationLocation fromDocumentPage(Consumer<DocumentPageLocation.Builder> documentPage) {
        DocumentPageLocation.Builder builder = DocumentPageLocation.builder();
        documentPage.accept(builder);
        return CitationLocation.fromDocumentPage((DocumentPageLocation)builder.build());
    }

    public static CitationLocation fromDocumentChunk(DocumentChunkLocation documentChunk) {
        return (CitationLocation)CitationLocation.builder().documentChunk(documentChunk).build();
    }

    public static CitationLocation fromDocumentChunk(Consumer<DocumentChunkLocation.Builder> documentChunk) {
        DocumentChunkLocation.Builder builder = DocumentChunkLocation.builder();
        documentChunk.accept(builder);
        return CitationLocation.fromDocumentChunk((DocumentChunkLocation)builder.build());
    }

    public static CitationLocation fromSearchResultLocation(SearchResultLocation searchResultLocation) {
        return (CitationLocation)CitationLocation.builder().searchResultLocation(searchResultLocation).build();
    }

    public static CitationLocation fromSearchResultLocation(Consumer<SearchResultLocation.Builder> searchResultLocation) {
        SearchResultLocation.Builder builder = SearchResultLocation.builder();
        searchResultLocation.accept(builder);
        return CitationLocation.fromSearchResultLocation((SearchResultLocation)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("web", WEB_FIELD);
        map.put("documentChar", DOCUMENT_CHAR_FIELD);
        map.put("documentPage", DOCUMENT_PAGE_FIELD);
        map.put("documentChunk", DOCUMENT_CHUNK_FIELD);
        map.put("searchResultLocation", SEARCH_RESULT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CitationLocation, T> g) {
        return obj -> g.apply((CitationLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        WEB,
        DOCUMENT_CHAR,
        DOCUMENT_PAGE,
        DOCUMENT_CHUNK,
        SEARCH_RESULT_LOCATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private WebLocation web;
        private DocumentCharLocation documentChar;
        private DocumentPageLocation documentPage;
        private DocumentChunkLocation documentChunk;
        private SearchResultLocation searchResultLocation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CitationLocation model) {
            this.web(model.web);
            this.documentChar(model.documentChar);
            this.documentPage(model.documentPage);
            this.documentChunk(model.documentChunk);
            this.searchResultLocation(model.searchResultLocation);
        }

        public final WebLocation.Builder getWeb() {
            return this.web != null ? this.web.toBuilder() : null;
        }

        public final void setWeb(WebLocation.BuilderImpl web) {
            WebLocation oldValue = this.web;
            this.web = web != null ? web.build() : null;
            this.handleUnionValueChange(Type.WEB, oldValue, this.web);
        }

        @Override
        public final Builder web(WebLocation web) {
            WebLocation oldValue = this.web;
            this.web = web;
            this.handleUnionValueChange(Type.WEB, oldValue, this.web);
            return this;
        }

        public final DocumentCharLocation.Builder getDocumentChar() {
            return this.documentChar != null ? this.documentChar.toBuilder() : null;
        }

        public final void setDocumentChar(DocumentCharLocation.BuilderImpl documentChar) {
            DocumentCharLocation oldValue = this.documentChar;
            this.documentChar = documentChar != null ? documentChar.build() : null;
            this.handleUnionValueChange(Type.DOCUMENT_CHAR, oldValue, this.documentChar);
        }

        @Override
        public final Builder documentChar(DocumentCharLocation documentChar) {
            DocumentCharLocation oldValue = this.documentChar;
            this.documentChar = documentChar;
            this.handleUnionValueChange(Type.DOCUMENT_CHAR, oldValue, this.documentChar);
            return this;
        }

        public final DocumentPageLocation.Builder getDocumentPage() {
            return this.documentPage != null ? this.documentPage.toBuilder() : null;
        }

        public final void setDocumentPage(DocumentPageLocation.BuilderImpl documentPage) {
            DocumentPageLocation oldValue = this.documentPage;
            this.documentPage = documentPage != null ? documentPage.build() : null;
            this.handleUnionValueChange(Type.DOCUMENT_PAGE, oldValue, this.documentPage);
        }

        @Override
        public final Builder documentPage(DocumentPageLocation documentPage) {
            DocumentPageLocation oldValue = this.documentPage;
            this.documentPage = documentPage;
            this.handleUnionValueChange(Type.DOCUMENT_PAGE, oldValue, this.documentPage);
            return this;
        }

        public final DocumentChunkLocation.Builder getDocumentChunk() {
            return this.documentChunk != null ? this.documentChunk.toBuilder() : null;
        }

        public final void setDocumentChunk(DocumentChunkLocation.BuilderImpl documentChunk) {
            DocumentChunkLocation oldValue = this.documentChunk;
            this.documentChunk = documentChunk != null ? documentChunk.build() : null;
            this.handleUnionValueChange(Type.DOCUMENT_CHUNK, oldValue, this.documentChunk);
        }

        @Override
        public final Builder documentChunk(DocumentChunkLocation documentChunk) {
            DocumentChunkLocation oldValue = this.documentChunk;
            this.documentChunk = documentChunk;
            this.handleUnionValueChange(Type.DOCUMENT_CHUNK, oldValue, this.documentChunk);
            return this;
        }

        public final SearchResultLocation.Builder getSearchResultLocation() {
            return this.searchResultLocation != null ? this.searchResultLocation.toBuilder() : null;
        }

        public final void setSearchResultLocation(SearchResultLocation.BuilderImpl searchResultLocation) {
            SearchResultLocation oldValue = this.searchResultLocation;
            this.searchResultLocation = searchResultLocation != null ? searchResultLocation.build() : null;
            this.handleUnionValueChange(Type.SEARCH_RESULT_LOCATION, oldValue, this.searchResultLocation);
        }

        @Override
        public final Builder searchResultLocation(SearchResultLocation searchResultLocation) {
            SearchResultLocation oldValue = this.searchResultLocation;
            this.searchResultLocation = searchResultLocation;
            this.handleUnionValueChange(Type.SEARCH_RESULT_LOCATION, oldValue, this.searchResultLocation);
            return this;
        }

        public CitationLocation build() {
            return new CitationLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CitationLocation> {
        public Builder web(WebLocation var1);

        default public Builder web(Consumer<WebLocation.Builder> web) {
            return this.web((WebLocation)((WebLocation.Builder)WebLocation.builder().applyMutation(web)).build());
        }

        public Builder documentChar(DocumentCharLocation var1);

        default public Builder documentChar(Consumer<DocumentCharLocation.Builder> documentChar) {
            return this.documentChar((DocumentCharLocation)((DocumentCharLocation.Builder)DocumentCharLocation.builder().applyMutation(documentChar)).build());
        }

        public Builder documentPage(DocumentPageLocation var1);

        default public Builder documentPage(Consumer<DocumentPageLocation.Builder> documentPage) {
            return this.documentPage((DocumentPageLocation)((DocumentPageLocation.Builder)DocumentPageLocation.builder().applyMutation(documentPage)).build());
        }

        public Builder documentChunk(DocumentChunkLocation var1);

        default public Builder documentChunk(Consumer<DocumentChunkLocation.Builder> documentChunk) {
            return this.documentChunk((DocumentChunkLocation)((DocumentChunkLocation.Builder)DocumentChunkLocation.builder().applyMutation(documentChunk)).build());
        }

        public Builder searchResultLocation(SearchResultLocation var1);

        default public Builder searchResultLocation(Consumer<SearchResultLocation.Builder> searchResultLocation) {
            return this.searchResultLocation((SearchResultLocation)((SearchResultLocation.Builder)SearchResultLocation.builder().applyMutation(searchResultLocation)).build());
        }
    }
}

