/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.AudioBlock;
import software.amazon.awssdk.services.bedrockruntime.model.CachePointBlock;
import software.amazon.awssdk.services.bedrockruntime.model.CitationsContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailConverseContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ImageBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ReasoningContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.SearchResultBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ToolUseBlock;
import software.amazon.awssdk.services.bedrockruntime.model.VideoBlock;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentBlock> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(ContentBlock.getter(ContentBlock::text)).setter(ContentBlock.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<ImageBlock> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("image").getter(ContentBlock.getter(ContentBlock::image)).setter(ContentBlock.setter(Builder::image)).constructor(ImageBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<DocumentBlock> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("document").getter(ContentBlock.getter(ContentBlock::document)).setter(ContentBlock.setter(Builder::document)).constructor(DocumentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final SdkField<VideoBlock> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("video").getter(ContentBlock.getter(ContentBlock::video)).setter(ContentBlock.setter(Builder::video)).constructor(VideoBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()}).build();
    private static final SdkField<AudioBlock> AUDIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audio").getter(ContentBlock.getter(ContentBlock::audio)).setter(ContentBlock.setter(Builder::audio)).constructor(AudioBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build()}).build();
    private static final SdkField<ToolUseBlock> TOOL_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolUse").getter(ContentBlock.getter(ContentBlock::toolUse)).setter(ContentBlock.setter(Builder::toolUse)).constructor(ToolUseBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUse").build()}).build();
    private static final SdkField<ToolResultBlock> TOOL_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolResult").getter(ContentBlock.getter(ContentBlock::toolResult)).setter(ContentBlock.setter(Builder::toolResult)).constructor(ToolResultBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolResult").build()}).build();
    private static final SdkField<GuardrailConverseContentBlock> GUARD_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardContent").getter(ContentBlock.getter(ContentBlock::guardContent)).setter(ContentBlock.setter(Builder::guardContent)).constructor(GuardrailConverseContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()}).build();
    private static final SdkField<CachePointBlock> CACHE_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cachePoint").getter(ContentBlock.getter(ContentBlock::cachePoint)).setter(ContentBlock.setter(Builder::cachePoint)).constructor(CachePointBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachePoint").build()}).build();
    private static final SdkField<ReasoningContentBlock> REASONING_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reasoningContent").getter(ContentBlock.getter(ContentBlock::reasoningContent)).setter(ContentBlock.setter(Builder::reasoningContent)).constructor(ReasoningContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasoningContent").build()}).build();
    private static final SdkField<CitationsContentBlock> CITATIONS_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("citationsContent").getter(ContentBlock.getter(ContentBlock::citationsContent)).setter(ContentBlock.setter(Builder::citationsContent)).constructor(CitationsContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citationsContent").build()}).build();
    private static final SdkField<SearchResultBlock> SEARCH_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("searchResult").getter(ContentBlock.getter(ContentBlock::searchResult)).setter(ContentBlock.setter(Builder::searchResult)).constructor(SearchResultBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, IMAGE_FIELD, DOCUMENT_FIELD, VIDEO_FIELD, AUDIO_FIELD, TOOL_USE_FIELD, TOOL_RESULT_FIELD, GUARD_CONTENT_FIELD, CACHE_POINT_FIELD, REASONING_CONTENT_FIELD, CITATIONS_CONTENT_FIELD, SEARCH_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContentBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final ImageBlock image;
    private final DocumentBlock document;
    private final VideoBlock video;
    private final AudioBlock audio;
    private final ToolUseBlock toolUse;
    private final ToolResultBlock toolResult;
    private final GuardrailConverseContentBlock guardContent;
    private final CachePointBlock cachePoint;
    private final ReasoningContentBlock reasoningContent;
    private final CitationsContentBlock citationsContent;
    private final SearchResultBlock searchResult;
    private final Type type;

    private ContentBlock(BuilderImpl builder) {
        this.text = builder.text;
        this.image = builder.image;
        this.document = builder.document;
        this.video = builder.video;
        this.audio = builder.audio;
        this.toolUse = builder.toolUse;
        this.toolResult = builder.toolResult;
        this.guardContent = builder.guardContent;
        this.cachePoint = builder.cachePoint;
        this.reasoningContent = builder.reasoningContent;
        this.citationsContent = builder.citationsContent;
        this.searchResult = builder.searchResult;
        this.type = builder.type;
    }

    public final String text() {
        return this.text;
    }

    public final ImageBlock image() {
        return this.image;
    }

    public final DocumentBlock document() {
        return this.document;
    }

    public final VideoBlock video() {
        return this.video;
    }

    public final AudioBlock audio() {
        return this.audio;
    }

    public final ToolUseBlock toolUse() {
        return this.toolUse;
    }

    public final ToolResultBlock toolResult() {
        return this.toolResult;
    }

    public final GuardrailConverseContentBlock guardContent() {
        return this.guardContent;
    }

    public final CachePointBlock cachePoint() {
        return this.cachePoint;
    }

    public final ReasoningContentBlock reasoningContent() {
        return this.reasoningContent;
    }

    public final CitationsContentBlock citationsContent() {
        return this.citationsContent;
    }

    public final SearchResultBlock searchResult() {
        return this.searchResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.audio());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolUse());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachePoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasoningContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.citationsContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlock)) {
            return false;
        }
        ContentBlock other = (ContentBlock)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.document(), other.document()) && Objects.equals(this.video(), other.video()) && Objects.equals(this.audio(), other.audio()) && Objects.equals(this.toolUse(), other.toolUse()) && Objects.equals(this.toolResult(), other.toolResult()) && Objects.equals(this.guardContent(), other.guardContent()) && Objects.equals(this.cachePoint(), other.cachePoint()) && Objects.equals(this.reasoningContent(), other.reasoningContent()) && Objects.equals(this.citationsContent(), other.citationsContent()) && Objects.equals(this.searchResult(), other.searchResult());
    }

    public final String toString() {
        return ToString.builder((String)"ContentBlock").add("Text", (Object)this.text()).add("Image", (Object)this.image()).add("Document", (Object)this.document()).add("Video", (Object)this.video()).add("Audio", (Object)this.audio()).add("ToolUse", (Object)this.toolUse()).add("ToolResult", (Object)this.toolResult()).add("GuardContent", (Object)this.guardContent()).add("CachePoint", (Object)this.cachePoint()).add("ReasoningContent", (Object)(this.reasoningContent() == null ? null : "*** Sensitive Data Redacted ***")).add("CitationsContent", (Object)this.citationsContent()).add("SearchResult", (Object)this.searchResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "audio": {
                return Optional.ofNullable(clazz.cast(this.audio()));
            }
            case "toolUse": {
                return Optional.ofNullable(clazz.cast(this.toolUse()));
            }
            case "toolResult": {
                return Optional.ofNullable(clazz.cast(this.toolResult()));
            }
            case "guardContent": {
                return Optional.ofNullable(clazz.cast(this.guardContent()));
            }
            case "cachePoint": {
                return Optional.ofNullable(clazz.cast(this.cachePoint()));
            }
            case "reasoningContent": {
                return Optional.ofNullable(clazz.cast(this.reasoningContent()));
            }
            case "citationsContent": {
                return Optional.ofNullable(clazz.cast(this.citationsContent()));
            }
            case "searchResult": {
                return Optional.ofNullable(clazz.cast(this.searchResult()));
            }
        }
        return Optional.empty();
    }

    public static ContentBlock fromText(String text) {
        return (ContentBlock)ContentBlock.builder().text(text).build();
    }

    public static ContentBlock fromImage(ImageBlock image) {
        return (ContentBlock)ContentBlock.builder().image(image).build();
    }

    public static ContentBlock fromImage(Consumer<ImageBlock.Builder> image) {
        ImageBlock.Builder builder = ImageBlock.builder();
        image.accept(builder);
        return ContentBlock.fromImage((ImageBlock)builder.build());
    }

    public static ContentBlock fromDocument(DocumentBlock document) {
        return (ContentBlock)ContentBlock.builder().document(document).build();
    }

    public static ContentBlock fromDocument(Consumer<DocumentBlock.Builder> document) {
        DocumentBlock.Builder builder = DocumentBlock.builder();
        document.accept(builder);
        return ContentBlock.fromDocument((DocumentBlock)builder.build());
    }

    public static ContentBlock fromVideo(VideoBlock video) {
        return (ContentBlock)ContentBlock.builder().video(video).build();
    }

    public static ContentBlock fromVideo(Consumer<VideoBlock.Builder> video) {
        VideoBlock.Builder builder = VideoBlock.builder();
        video.accept(builder);
        return ContentBlock.fromVideo((VideoBlock)builder.build());
    }

    public static ContentBlock fromAudio(AudioBlock audio) {
        return (ContentBlock)ContentBlock.builder().audio(audio).build();
    }

    public static ContentBlock fromAudio(Consumer<AudioBlock.Builder> audio) {
        AudioBlock.Builder builder = AudioBlock.builder();
        audio.accept(builder);
        return ContentBlock.fromAudio((AudioBlock)builder.build());
    }

    public static ContentBlock fromToolUse(ToolUseBlock toolUse) {
        return (ContentBlock)ContentBlock.builder().toolUse(toolUse).build();
    }

    public static ContentBlock fromToolUse(Consumer<ToolUseBlock.Builder> toolUse) {
        ToolUseBlock.Builder builder = ToolUseBlock.builder();
        toolUse.accept(builder);
        return ContentBlock.fromToolUse((ToolUseBlock)builder.build());
    }

    public static ContentBlock fromToolResult(ToolResultBlock toolResult) {
        return (ContentBlock)ContentBlock.builder().toolResult(toolResult).build();
    }

    public static ContentBlock fromToolResult(Consumer<ToolResultBlock.Builder> toolResult) {
        ToolResultBlock.Builder builder = ToolResultBlock.builder();
        toolResult.accept(builder);
        return ContentBlock.fromToolResult((ToolResultBlock)builder.build());
    }

    public static ContentBlock fromGuardContent(GuardrailConverseContentBlock guardContent) {
        return (ContentBlock)ContentBlock.builder().guardContent(guardContent).build();
    }

    public static ContentBlock fromGuardContent(Consumer<GuardrailConverseContentBlock.Builder> guardContent) {
        GuardrailConverseContentBlock.Builder builder = GuardrailConverseContentBlock.builder();
        guardContent.accept(builder);
        return ContentBlock.fromGuardContent((GuardrailConverseContentBlock)builder.build());
    }

    public static ContentBlock fromCachePoint(CachePointBlock cachePoint) {
        return (ContentBlock)ContentBlock.builder().cachePoint(cachePoint).build();
    }

    public static ContentBlock fromCachePoint(Consumer<CachePointBlock.Builder> cachePoint) {
        CachePointBlock.Builder builder = CachePointBlock.builder();
        cachePoint.accept(builder);
        return ContentBlock.fromCachePoint((CachePointBlock)builder.build());
    }

    public static ContentBlock fromReasoningContent(ReasoningContentBlock reasoningContent) {
        return (ContentBlock)ContentBlock.builder().reasoningContent(reasoningContent).build();
    }

    public static ContentBlock fromReasoningContent(Consumer<ReasoningContentBlock.Builder> reasoningContent) {
        ReasoningContentBlock.Builder builder = ReasoningContentBlock.builder();
        reasoningContent.accept(builder);
        return ContentBlock.fromReasoningContent((ReasoningContentBlock)builder.build());
    }

    public static ContentBlock fromCitationsContent(CitationsContentBlock citationsContent) {
        return (ContentBlock)ContentBlock.builder().citationsContent(citationsContent).build();
    }

    public static ContentBlock fromCitationsContent(Consumer<CitationsContentBlock.Builder> citationsContent) {
        CitationsContentBlock.Builder builder = CitationsContentBlock.builder();
        citationsContent.accept(builder);
        return ContentBlock.fromCitationsContent((CitationsContentBlock)builder.build());
    }

    public static ContentBlock fromSearchResult(SearchResultBlock searchResult) {
        return (ContentBlock)ContentBlock.builder().searchResult(searchResult).build();
    }

    public static ContentBlock fromSearchResult(Consumer<SearchResultBlock.Builder> searchResult) {
        SearchResultBlock.Builder builder = SearchResultBlock.builder();
        searchResult.accept(builder);
        return ContentBlock.fromSearchResult((SearchResultBlock)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", TEXT_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("document", DOCUMENT_FIELD);
        map.put("video", VIDEO_FIELD);
        map.put("audio", AUDIO_FIELD);
        map.put("toolUse", TOOL_USE_FIELD);
        map.put("toolResult", TOOL_RESULT_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("cachePoint", CACHE_POINT_FIELD);
        map.put("reasoningContent", REASONING_CONTENT_FIELD);
        map.put("citationsContent", CITATIONS_CONTENT_FIELD);
        map.put("searchResult", SEARCH_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentBlock, T> g) {
        return obj -> g.apply((ContentBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        IMAGE,
        DOCUMENT,
        VIDEO,
        AUDIO,
        TOOL_USE,
        TOOL_RESULT,
        GUARD_CONTENT,
        CACHE_POINT,
        REASONING_CONTENT,
        CITATIONS_CONTENT,
        SEARCH_RESULT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private ImageBlock image;
        private DocumentBlock document;
        private VideoBlock video;
        private AudioBlock audio;
        private ToolUseBlock toolUse;
        private ToolResultBlock toolResult;
        private GuardrailConverseContentBlock guardContent;
        private CachePointBlock cachePoint;
        private ReasoningContentBlock reasoningContent;
        private CitationsContentBlock citationsContent;
        private SearchResultBlock searchResult;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBlock model) {
            this.text(model.text);
            this.image(model.image);
            this.document(model.document);
            this.video(model.video);
            this.audio(model.audio);
            this.toolUse(model.toolUse);
            this.toolResult(model.toolResult);
            this.guardContent(model.guardContent);
            this.cachePoint(model.cachePoint);
            this.reasoningContent(model.reasoningContent);
            this.citationsContent(model.citationsContent);
            this.searchResult(model.searchResult);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ImageBlock.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(ImageBlock.BuilderImpl image) {
            ImageBlock oldValue = this.image;
            this.image = image != null ? image.build() : null;
            this.handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(ImageBlock image) {
            ImageBlock oldValue = this.image;
            this.image = image;
            this.handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        public final DocumentBlock.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(DocumentBlock.BuilderImpl document) {
            DocumentBlock oldValue = this.document;
            this.document = document != null ? document.build() : null;
            this.handleUnionValueChange(Type.DOCUMENT, oldValue, this.document);
        }

        @Override
        public final Builder document(DocumentBlock document) {
            DocumentBlock oldValue = this.document;
            this.document = document;
            this.handleUnionValueChange(Type.DOCUMENT, oldValue, this.document);
            return this;
        }

        public final VideoBlock.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(VideoBlock.BuilderImpl video) {
            VideoBlock oldValue = this.video;
            this.video = video != null ? video.build() : null;
            this.handleUnionValueChange(Type.VIDEO, oldValue, this.video);
        }

        @Override
        public final Builder video(VideoBlock video) {
            VideoBlock oldValue = this.video;
            this.video = video;
            this.handleUnionValueChange(Type.VIDEO, oldValue, this.video);
            return this;
        }

        public final AudioBlock.Builder getAudio() {
            return this.audio != null ? this.audio.toBuilder() : null;
        }

        public final void setAudio(AudioBlock.BuilderImpl audio) {
            AudioBlock oldValue = this.audio;
            this.audio = audio != null ? audio.build() : null;
            this.handleUnionValueChange(Type.AUDIO, oldValue, this.audio);
        }

        @Override
        public final Builder audio(AudioBlock audio) {
            AudioBlock oldValue = this.audio;
            this.audio = audio;
            this.handleUnionValueChange(Type.AUDIO, oldValue, this.audio);
            return this;
        }

        public final ToolUseBlock.Builder getToolUse() {
            return this.toolUse != null ? this.toolUse.toBuilder() : null;
        }

        public final void setToolUse(ToolUseBlock.BuilderImpl toolUse) {
            ToolUseBlock oldValue = this.toolUse;
            this.toolUse = toolUse != null ? toolUse.build() : null;
            this.handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
        }

        @Override
        public final Builder toolUse(ToolUseBlock toolUse) {
            ToolUseBlock oldValue = this.toolUse;
            this.toolUse = toolUse;
            this.handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
            return this;
        }

        public final ToolResultBlock.Builder getToolResult() {
            return this.toolResult != null ? this.toolResult.toBuilder() : null;
        }

        public final void setToolResult(ToolResultBlock.BuilderImpl toolResult) {
            ToolResultBlock oldValue = this.toolResult;
            this.toolResult = toolResult != null ? toolResult.build() : null;
            this.handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
        }

        @Override
        public final Builder toolResult(ToolResultBlock toolResult) {
            ToolResultBlock oldValue = this.toolResult;
            this.toolResult = toolResult;
            this.handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
            return this;
        }

        public final GuardrailConverseContentBlock.Builder getGuardContent() {
            return this.guardContent != null ? this.guardContent.toBuilder() : null;
        }

        public final void setGuardContent(GuardrailConverseContentBlock.BuilderImpl guardContent) {
            GuardrailConverseContentBlock oldValue = this.guardContent;
            this.guardContent = guardContent != null ? guardContent.build() : null;
            this.handleUnionValueChange(Type.GUARD_CONTENT, oldValue, this.guardContent);
        }

        @Override
        public final Builder guardContent(GuardrailConverseContentBlock guardContent) {
            GuardrailConverseContentBlock oldValue = this.guardContent;
            this.guardContent = guardContent;
            this.handleUnionValueChange(Type.GUARD_CONTENT, oldValue, this.guardContent);
            return this;
        }

        public final CachePointBlock.Builder getCachePoint() {
            return this.cachePoint != null ? this.cachePoint.toBuilder() : null;
        }

        public final void setCachePoint(CachePointBlock.BuilderImpl cachePoint) {
            CachePointBlock oldValue = this.cachePoint;
            this.cachePoint = cachePoint != null ? cachePoint.build() : null;
            this.handleUnionValueChange(Type.CACHE_POINT, oldValue, this.cachePoint);
        }

        @Override
        public final Builder cachePoint(CachePointBlock cachePoint) {
            CachePointBlock oldValue = this.cachePoint;
            this.cachePoint = cachePoint;
            this.handleUnionValueChange(Type.CACHE_POINT, oldValue, this.cachePoint);
            return this;
        }

        public final ReasoningContentBlock.Builder getReasoningContent() {
            return this.reasoningContent != null ? this.reasoningContent.toBuilder() : null;
        }

        public final void setReasoningContent(ReasoningContentBlock.BuilderImpl reasoningContent) {
            ReasoningContentBlock oldValue = this.reasoningContent;
            this.reasoningContent = reasoningContent != null ? reasoningContent.build() : null;
            this.handleUnionValueChange(Type.REASONING_CONTENT, oldValue, this.reasoningContent);
        }

        @Override
        public final Builder reasoningContent(ReasoningContentBlock reasoningContent) {
            ReasoningContentBlock oldValue = this.reasoningContent;
            this.reasoningContent = reasoningContent;
            this.handleUnionValueChange(Type.REASONING_CONTENT, oldValue, this.reasoningContent);
            return this;
        }

        public final CitationsContentBlock.Builder getCitationsContent() {
            return this.citationsContent != null ? this.citationsContent.toBuilder() : null;
        }

        public final void setCitationsContent(CitationsContentBlock.BuilderImpl citationsContent) {
            CitationsContentBlock oldValue = this.citationsContent;
            this.citationsContent = citationsContent != null ? citationsContent.build() : null;
            this.handleUnionValueChange(Type.CITATIONS_CONTENT, oldValue, this.citationsContent);
        }

        @Override
        public final Builder citationsContent(CitationsContentBlock citationsContent) {
            CitationsContentBlock oldValue = this.citationsContent;
            this.citationsContent = citationsContent;
            this.handleUnionValueChange(Type.CITATIONS_CONTENT, oldValue, this.citationsContent);
            return this;
        }

        public final SearchResultBlock.Builder getSearchResult() {
            return this.searchResult != null ? this.searchResult.toBuilder() : null;
        }

        public final void setSearchResult(SearchResultBlock.BuilderImpl searchResult) {
            SearchResultBlock oldValue = this.searchResult;
            this.searchResult = searchResult != null ? searchResult.build() : null;
            this.handleUnionValueChange(Type.SEARCH_RESULT, oldValue, this.searchResult);
        }

        @Override
        public final Builder searchResult(SearchResultBlock searchResult) {
            SearchResultBlock oldValue = this.searchResult;
            this.searchResult = searchResult;
            this.handleUnionValueChange(Type.SEARCH_RESULT, oldValue, this.searchResult);
            return this;
        }

        public ContentBlock build() {
            return new ContentBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentBlock> {
        public Builder text(String var1);

        public Builder image(ImageBlock var1);

        default public Builder image(Consumer<ImageBlock.Builder> image) {
            return this.image((ImageBlock)((ImageBlock.Builder)ImageBlock.builder().applyMutation(image)).build());
        }

        public Builder document(DocumentBlock var1);

        default public Builder document(Consumer<DocumentBlock.Builder> document) {
            return this.document((DocumentBlock)((DocumentBlock.Builder)DocumentBlock.builder().applyMutation(document)).build());
        }

        public Builder video(VideoBlock var1);

        default public Builder video(Consumer<VideoBlock.Builder> video) {
            return this.video((VideoBlock)((VideoBlock.Builder)VideoBlock.builder().applyMutation(video)).build());
        }

        public Builder audio(AudioBlock var1);

        default public Builder audio(Consumer<AudioBlock.Builder> audio) {
            return this.audio((AudioBlock)((AudioBlock.Builder)AudioBlock.builder().applyMutation(audio)).build());
        }

        public Builder toolUse(ToolUseBlock var1);

        default public Builder toolUse(Consumer<ToolUseBlock.Builder> toolUse) {
            return this.toolUse((ToolUseBlock)((ToolUseBlock.Builder)ToolUseBlock.builder().applyMutation(toolUse)).build());
        }

        public Builder toolResult(ToolResultBlock var1);

        default public Builder toolResult(Consumer<ToolResultBlock.Builder> toolResult) {
            return this.toolResult((ToolResultBlock)((ToolResultBlock.Builder)ToolResultBlock.builder().applyMutation(toolResult)).build());
        }

        public Builder guardContent(GuardrailConverseContentBlock var1);

        default public Builder guardContent(Consumer<GuardrailConverseContentBlock.Builder> guardContent) {
            return this.guardContent((GuardrailConverseContentBlock)((GuardrailConverseContentBlock.Builder)GuardrailConverseContentBlock.builder().applyMutation(guardContent)).build());
        }

        public Builder cachePoint(CachePointBlock var1);

        default public Builder cachePoint(Consumer<CachePointBlock.Builder> cachePoint) {
            return this.cachePoint((CachePointBlock)((CachePointBlock.Builder)CachePointBlock.builder().applyMutation(cachePoint)).build());
        }

        public Builder reasoningContent(ReasoningContentBlock var1);

        default public Builder reasoningContent(Consumer<ReasoningContentBlock.Builder> reasoningContent) {
            return this.reasoningContent((ReasoningContentBlock)((ReasoningContentBlock.Builder)ReasoningContentBlock.builder().applyMutation(reasoningContent)).build());
        }

        public Builder citationsContent(CitationsContentBlock var1);

        default public Builder citationsContent(Consumer<CitationsContentBlock.Builder> citationsContent) {
            return this.citationsContent((CitationsContentBlock)((CitationsContentBlock.Builder)CitationsContentBlock.builder().applyMutation(citationsContent)).build());
        }

        public Builder searchResult(SearchResultBlock var1);

        default public Builder searchResult(Consumer<SearchResultBlock.Builder> searchResult) {
            return this.searchResult((SearchResultBlock)((SearchResultBlock.Builder)SearchResultBlock.builder().applyMutation(searchResult)).build());
        }
    }
}

