/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.ChatbotRequest;
import software.amazon.awssdk.services.chatbot.model.GuardrailPolicyArnListCopier;
import software.amazon.awssdk.services.chatbot.model.SnsTopicArnListCopier;
import software.amazon.awssdk.services.chatbot.model.Tag;
import software.amazon.awssdk.services.chatbot.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMicrosoftTeamsChannelConfigurationRequest
extends ChatbotRequest
implements ToCopyableBuilder<Builder, CreateMicrosoftTeamsChannelConfigurationRequest> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::channelId)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::channelName)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> TEAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TeamId").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::teamId)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::teamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()}).build();
    private static final SdkField<String> TEAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TeamName").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::teamName)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::teamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamName").build()}).build();
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantId").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::tenantId)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()}).build();
    private static final SdkField<List<String>> SNS_TOPIC_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnsTopicArns").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::snsTopicArns)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::snsTopicArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::iamRoleArn)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationName").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::configurationName)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::configurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()}).build();
    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingLevel").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::loggingLevel)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::loggingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()}).build();
    private static final SdkField<List<String>> GUARDRAIL_POLICY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GuardrailPolicyArns").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::guardrailPolicyArns)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::guardrailPolicyArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuardrailPolicyArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USER_AUTHORIZATION_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UserAuthorizationRequired").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::userAuthorizationRequired)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::userAuthorizationRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAuthorizationRequired").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMicrosoftTeamsChannelConfigurationRequest.getter(CreateMicrosoftTeamsChannelConfigurationRequest::tags)).setter(CreateMicrosoftTeamsChannelConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, CHANNEL_NAME_FIELD, TEAM_ID_FIELD, TEAM_NAME_FIELD, TENANT_ID_FIELD, SNS_TOPIC_ARNS_FIELD, IAM_ROLE_ARN_FIELD, CONFIGURATION_NAME_FIELD, LOGGING_LEVEL_FIELD, GUARDRAIL_POLICY_ARNS_FIELD, USER_AUTHORIZATION_REQUIRED_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMicrosoftTeamsChannelConfigurationRequest.memberNameToFieldInitializer();
    private final String channelId;
    private final String channelName;
    private final String teamId;
    private final String teamName;
    private final String tenantId;
    private final List<String> snsTopicArns;
    private final String iamRoleArn;
    private final String configurationName;
    private final String loggingLevel;
    private final List<String> guardrailPolicyArns;
    private final Boolean userAuthorizationRequired;
    private final List<Tag> tags;

    private CreateMicrosoftTeamsChannelConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.channelName = builder.channelName;
        this.teamId = builder.teamId;
        this.teamName = builder.teamName;
        this.tenantId = builder.tenantId;
        this.snsTopicArns = builder.snsTopicArns;
        this.iamRoleArn = builder.iamRoleArn;
        this.configurationName = builder.configurationName;
        this.loggingLevel = builder.loggingLevel;
        this.guardrailPolicyArns = builder.guardrailPolicyArns;
        this.userAuthorizationRequired = builder.userAuthorizationRequired;
        this.tags = builder.tags;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String teamId() {
        return this.teamId;
    }

    public final String teamName() {
        return this.teamName;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    public final boolean hasSnsTopicArns() {
        return this.snsTopicArns != null && !(this.snsTopicArns instanceof SdkAutoConstructList);
    }

    public final List<String> snsTopicArns() {
        return this.snsTopicArns;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String configurationName() {
        return this.configurationName;
    }

    public final String loggingLevel() {
        return this.loggingLevel;
    }

    public final boolean hasGuardrailPolicyArns() {
        return this.guardrailPolicyArns != null && !(this.guardrailPolicyArns instanceof SdkAutoConstructList);
    }

    public final List<String> guardrailPolicyArns() {
        return this.guardrailPolicyArns;
    }

    public final Boolean userAuthorizationRequired() {
        return this.userAuthorizationRequired;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.teamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.teamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnsTopicArns() ? this.snsTopicArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGuardrailPolicyArns() ? this.guardrailPolicyArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userAuthorizationRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMicrosoftTeamsChannelConfigurationRequest)) {
            return false;
        }
        CreateMicrosoftTeamsChannelConfigurationRequest other = (CreateMicrosoftTeamsChannelConfigurationRequest)((Object)obj);
        return Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.teamId(), other.teamId()) && Objects.equals(this.teamName(), other.teamName()) && Objects.equals(this.tenantId(), other.tenantId()) && this.hasSnsTopicArns() == other.hasSnsTopicArns() && Objects.equals(this.snsTopicArns(), other.snsTopicArns()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.loggingLevel(), other.loggingLevel()) && this.hasGuardrailPolicyArns() == other.hasGuardrailPolicyArns() && Objects.equals(this.guardrailPolicyArns(), other.guardrailPolicyArns()) && Objects.equals(this.userAuthorizationRequired(), other.userAuthorizationRequired()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMicrosoftTeamsChannelConfigurationRequest").add("ChannelId", (Object)this.channelId()).add("ChannelName", (Object)(this.channelName() == null ? null : "*** Sensitive Data Redacted ***")).add("TeamId", (Object)this.teamId()).add("TeamName", (Object)(this.teamName() == null ? null : "*** Sensitive Data Redacted ***")).add("TenantId", (Object)this.tenantId()).add("SnsTopicArns", this.hasSnsTopicArns() ? this.snsTopicArns() : null).add("IamRoleArn", (Object)this.iamRoleArn()).add("ConfigurationName", (Object)this.configurationName()).add("LoggingLevel", (Object)this.loggingLevel()).add("GuardrailPolicyArns", this.hasGuardrailPolicyArns() ? this.guardrailPolicyArns() : null).add("UserAuthorizationRequired", (Object)this.userAuthorizationRequired()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "TeamId": {
                return Optional.ofNullable(clazz.cast(this.teamId()));
            }
            case "TeamName": {
                return Optional.ofNullable(clazz.cast(this.teamName()));
            }
            case "TenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
            case "SnsTopicArns": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArns()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "ConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.configurationName()));
            }
            case "LoggingLevel": {
                return Optional.ofNullable(clazz.cast(this.loggingLevel()));
            }
            case "GuardrailPolicyArns": {
                return Optional.ofNullable(clazz.cast(this.guardrailPolicyArns()));
            }
            case "UserAuthorizationRequired": {
                return Optional.ofNullable(clazz.cast(this.userAuthorizationRequired()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelId", CHANNEL_ID_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("TeamId", TEAM_ID_FIELD);
        map.put("TeamName", TEAM_NAME_FIELD);
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("SnsTopicArns", SNS_TOPIC_ARNS_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("ConfigurationName", CONFIGURATION_NAME_FIELD);
        map.put("LoggingLevel", LOGGING_LEVEL_FIELD);
        map.put("GuardrailPolicyArns", GUARDRAIL_POLICY_ARNS_FIELD);
        map.put("UserAuthorizationRequired", USER_AUTHORIZATION_REQUIRED_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMicrosoftTeamsChannelConfigurationRequest, T> g) {
        return obj -> g.apply((CreateMicrosoftTeamsChannelConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChatbotRequest.BuilderImpl
    implements Builder {
        private String channelId;
        private String channelName;
        private String teamId;
        private String teamName;
        private String tenantId;
        private List<String> snsTopicArns = DefaultSdkAutoConstructList.getInstance();
        private String iamRoleArn;
        private String configurationName;
        private String loggingLevel;
        private List<String> guardrailPolicyArns = DefaultSdkAutoConstructList.getInstance();
        private Boolean userAuthorizationRequired;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMicrosoftTeamsChannelConfigurationRequest model) {
            super(model);
            this.channelId(model.channelId);
            this.channelName(model.channelName);
            this.teamId(model.teamId);
            this.teamName(model.teamName);
            this.tenantId(model.tenantId);
            this.snsTopicArns(model.snsTopicArns);
            this.iamRoleArn(model.iamRoleArn);
            this.configurationName(model.configurationName);
            this.loggingLevel(model.loggingLevel);
            this.guardrailPolicyArns(model.guardrailPolicyArns);
            this.userAuthorizationRequired(model.userAuthorizationRequired);
            this.tags(model.tags);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getTeamId() {
            return this.teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getTeamName() {
            return this.teamName;
        }

        public final void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @Override
        public final Builder teamName(String teamName) {
            this.teamName = teamName;
            return this;
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Collection<String> getSnsTopicArns() {
            if (this.snsTopicArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snsTopicArns;
        }

        public final void setSnsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
        }

        @Override
        public final Builder snsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snsTopicArns(String ... snsTopicArns) {
            this.snsTopicArns(Arrays.asList(snsTopicArns));
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getLoggingLevel() {
            return this.loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public final Collection<String> getGuardrailPolicyArns() {
            if (this.guardrailPolicyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.guardrailPolicyArns;
        }

        public final void setGuardrailPolicyArns(Collection<String> guardrailPolicyArns) {
            this.guardrailPolicyArns = GuardrailPolicyArnListCopier.copy(guardrailPolicyArns);
        }

        @Override
        public final Builder guardrailPolicyArns(Collection<String> guardrailPolicyArns) {
            this.guardrailPolicyArns = GuardrailPolicyArnListCopier.copy(guardrailPolicyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailPolicyArns(String ... guardrailPolicyArns) {
            this.guardrailPolicyArns(Arrays.asList(guardrailPolicyArns));
            return this;
        }

        public final Boolean getUserAuthorizationRequired() {
            return this.userAuthorizationRequired;
        }

        public final void setUserAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
        }

        @Override
        public final Builder userAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMicrosoftTeamsChannelConfigurationRequest build() {
            return new CreateMicrosoftTeamsChannelConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChatbotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMicrosoftTeamsChannelConfigurationRequest> {
        public Builder channelId(String var1);

        public Builder channelName(String var1);

        public Builder teamId(String var1);

        public Builder teamName(String var1);

        public Builder tenantId(String var1);

        public Builder snsTopicArns(Collection<String> var1);

        public Builder snsTopicArns(String ... var1);

        public Builder iamRoleArn(String var1);

        public Builder configurationName(String var1);

        public Builder loggingLevel(String var1);

        public Builder guardrailPolicyArns(Collection<String> var1);

        public Builder guardrailPolicyArns(String ... var1);

        public Builder userAuthorizationRequired(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

