/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CanvasOrientation;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ContentShareLayoutOption;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.HorizontalLayoutConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.PresenterOnlyConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.VerticalLayoutConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GridViewConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GridViewConfiguration> {
    private static final SdkField<String> CONTENT_SHARE_LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentShareLayout").getter(GridViewConfiguration.getter(GridViewConfiguration::contentShareLayoutAsString)).setter(GridViewConfiguration.setter(Builder::contentShareLayout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentShareLayout").build()}).build();
    private static final SdkField<PresenterOnlyConfiguration> PRESENTER_ONLY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PresenterOnlyConfiguration").getter(GridViewConfiguration.getter(GridViewConfiguration::presenterOnlyConfiguration)).setter(GridViewConfiguration.setter(Builder::presenterOnlyConfiguration)).constructor(PresenterOnlyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresenterOnlyConfiguration").build()}).build();
    private static final SdkField<ActiveSpeakerOnlyConfiguration> ACTIVE_SPEAKER_ONLY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActiveSpeakerOnlyConfiguration").getter(GridViewConfiguration.getter(GridViewConfiguration::activeSpeakerOnlyConfiguration)).setter(GridViewConfiguration.setter(Builder::activeSpeakerOnlyConfiguration)).constructor(ActiveSpeakerOnlyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveSpeakerOnlyConfiguration").build()}).build();
    private static final SdkField<HorizontalLayoutConfiguration> HORIZONTAL_LAYOUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HorizontalLayoutConfiguration").getter(GridViewConfiguration.getter(GridViewConfiguration::horizontalLayoutConfiguration)).setter(GridViewConfiguration.setter(Builder::horizontalLayoutConfiguration)).constructor(HorizontalLayoutConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HorizontalLayoutConfiguration").build()}).build();
    private static final SdkField<VerticalLayoutConfiguration> VERTICAL_LAYOUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VerticalLayoutConfiguration").getter(GridViewConfiguration.getter(GridViewConfiguration::verticalLayoutConfiguration)).setter(GridViewConfiguration.setter(Builder::verticalLayoutConfiguration)).constructor(VerticalLayoutConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerticalLayoutConfiguration").build()}).build();
    private static final SdkField<VideoAttribute> VIDEO_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoAttribute").getter(GridViewConfiguration.getter(GridViewConfiguration::videoAttribute)).setter(GridViewConfiguration.setter(Builder::videoAttribute)).constructor(VideoAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoAttribute").build()}).build();
    private static final SdkField<String> CANVAS_ORIENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CanvasOrientation").getter(GridViewConfiguration.getter(GridViewConfiguration::canvasOrientationAsString)).setter(GridViewConfiguration.setter(Builder::canvasOrientation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanvasOrientation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_SHARE_LAYOUT_FIELD, PRESENTER_ONLY_CONFIGURATION_FIELD, ACTIVE_SPEAKER_ONLY_CONFIGURATION_FIELD, HORIZONTAL_LAYOUT_CONFIGURATION_FIELD, VERTICAL_LAYOUT_CONFIGURATION_FIELD, VIDEO_ATTRIBUTE_FIELD, CANVAS_ORIENTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GridViewConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contentShareLayout;
    private final PresenterOnlyConfiguration presenterOnlyConfiguration;
    private final ActiveSpeakerOnlyConfiguration activeSpeakerOnlyConfiguration;
    private final HorizontalLayoutConfiguration horizontalLayoutConfiguration;
    private final VerticalLayoutConfiguration verticalLayoutConfiguration;
    private final VideoAttribute videoAttribute;
    private final String canvasOrientation;

    private GridViewConfiguration(BuilderImpl builder) {
        this.contentShareLayout = builder.contentShareLayout;
        this.presenterOnlyConfiguration = builder.presenterOnlyConfiguration;
        this.activeSpeakerOnlyConfiguration = builder.activeSpeakerOnlyConfiguration;
        this.horizontalLayoutConfiguration = builder.horizontalLayoutConfiguration;
        this.verticalLayoutConfiguration = builder.verticalLayoutConfiguration;
        this.videoAttribute = builder.videoAttribute;
        this.canvasOrientation = builder.canvasOrientation;
    }

    public final ContentShareLayoutOption contentShareLayout() {
        return ContentShareLayoutOption.fromValue(this.contentShareLayout);
    }

    public final String contentShareLayoutAsString() {
        return this.contentShareLayout;
    }

    public final PresenterOnlyConfiguration presenterOnlyConfiguration() {
        return this.presenterOnlyConfiguration;
    }

    public final ActiveSpeakerOnlyConfiguration activeSpeakerOnlyConfiguration() {
        return this.activeSpeakerOnlyConfiguration;
    }

    public final HorizontalLayoutConfiguration horizontalLayoutConfiguration() {
        return this.horizontalLayoutConfiguration;
    }

    public final VerticalLayoutConfiguration verticalLayoutConfiguration() {
        return this.verticalLayoutConfiguration;
    }

    public final VideoAttribute videoAttribute() {
        return this.videoAttribute;
    }

    public final CanvasOrientation canvasOrientation() {
        return CanvasOrientation.fromValue(this.canvasOrientation);
    }

    public final String canvasOrientationAsString() {
        return this.canvasOrientation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentShareLayoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.presenterOnlyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeSpeakerOnlyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.horizontalLayoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.verticalLayoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.canvasOrientationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridViewConfiguration)) {
            return false;
        }
        GridViewConfiguration other = (GridViewConfiguration)obj;
        return Objects.equals(this.contentShareLayoutAsString(), other.contentShareLayoutAsString()) && Objects.equals(this.presenterOnlyConfiguration(), other.presenterOnlyConfiguration()) && Objects.equals(this.activeSpeakerOnlyConfiguration(), other.activeSpeakerOnlyConfiguration()) && Objects.equals(this.horizontalLayoutConfiguration(), other.horizontalLayoutConfiguration()) && Objects.equals(this.verticalLayoutConfiguration(), other.verticalLayoutConfiguration()) && Objects.equals(this.videoAttribute(), other.videoAttribute()) && Objects.equals(this.canvasOrientationAsString(), other.canvasOrientationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GridViewConfiguration").add("ContentShareLayout", (Object)this.contentShareLayoutAsString()).add("PresenterOnlyConfiguration", (Object)this.presenterOnlyConfiguration()).add("ActiveSpeakerOnlyConfiguration", (Object)this.activeSpeakerOnlyConfiguration()).add("HorizontalLayoutConfiguration", (Object)this.horizontalLayoutConfiguration()).add("VerticalLayoutConfiguration", (Object)this.verticalLayoutConfiguration()).add("VideoAttribute", (Object)this.videoAttribute()).add("CanvasOrientation", (Object)this.canvasOrientationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentShareLayout": {
                return Optional.ofNullable(clazz.cast(this.contentShareLayoutAsString()));
            }
            case "PresenterOnlyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.presenterOnlyConfiguration()));
            }
            case "ActiveSpeakerOnlyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.activeSpeakerOnlyConfiguration()));
            }
            case "HorizontalLayoutConfiguration": {
                return Optional.ofNullable(clazz.cast(this.horizontalLayoutConfiguration()));
            }
            case "VerticalLayoutConfiguration": {
                return Optional.ofNullable(clazz.cast(this.verticalLayoutConfiguration()));
            }
            case "VideoAttribute": {
                return Optional.ofNullable(clazz.cast(this.videoAttribute()));
            }
            case "CanvasOrientation": {
                return Optional.ofNullable(clazz.cast(this.canvasOrientationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContentShareLayout", CONTENT_SHARE_LAYOUT_FIELD);
        map.put("PresenterOnlyConfiguration", PRESENTER_ONLY_CONFIGURATION_FIELD);
        map.put("ActiveSpeakerOnlyConfiguration", ACTIVE_SPEAKER_ONLY_CONFIGURATION_FIELD);
        map.put("HorizontalLayoutConfiguration", HORIZONTAL_LAYOUT_CONFIGURATION_FIELD);
        map.put("VerticalLayoutConfiguration", VERTICAL_LAYOUT_CONFIGURATION_FIELD);
        map.put("VideoAttribute", VIDEO_ATTRIBUTE_FIELD);
        map.put("CanvasOrientation", CANVAS_ORIENTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GridViewConfiguration, T> g) {
        return obj -> g.apply((GridViewConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentShareLayout;
        private PresenterOnlyConfiguration presenterOnlyConfiguration;
        private ActiveSpeakerOnlyConfiguration activeSpeakerOnlyConfiguration;
        private HorizontalLayoutConfiguration horizontalLayoutConfiguration;
        private VerticalLayoutConfiguration verticalLayoutConfiguration;
        private VideoAttribute videoAttribute;
        private String canvasOrientation;

        private BuilderImpl() {
        }

        private BuilderImpl(GridViewConfiguration model) {
            this.contentShareLayout(model.contentShareLayout);
            this.presenterOnlyConfiguration(model.presenterOnlyConfiguration);
            this.activeSpeakerOnlyConfiguration(model.activeSpeakerOnlyConfiguration);
            this.horizontalLayoutConfiguration(model.horizontalLayoutConfiguration);
            this.verticalLayoutConfiguration(model.verticalLayoutConfiguration);
            this.videoAttribute(model.videoAttribute);
            this.canvasOrientation(model.canvasOrientation);
        }

        public final String getContentShareLayout() {
            return this.contentShareLayout;
        }

        public final void setContentShareLayout(String contentShareLayout) {
            this.contentShareLayout = contentShareLayout;
        }

        @Override
        public final Builder contentShareLayout(String contentShareLayout) {
            this.contentShareLayout = contentShareLayout;
            return this;
        }

        @Override
        public final Builder contentShareLayout(ContentShareLayoutOption contentShareLayout) {
            this.contentShareLayout(contentShareLayout == null ? null : contentShareLayout.toString());
            return this;
        }

        public final PresenterOnlyConfiguration.Builder getPresenterOnlyConfiguration() {
            return this.presenterOnlyConfiguration != null ? this.presenterOnlyConfiguration.toBuilder() : null;
        }

        public final void setPresenterOnlyConfiguration(PresenterOnlyConfiguration.BuilderImpl presenterOnlyConfiguration) {
            this.presenterOnlyConfiguration = presenterOnlyConfiguration != null ? presenterOnlyConfiguration.build() : null;
        }

        @Override
        public final Builder presenterOnlyConfiguration(PresenterOnlyConfiguration presenterOnlyConfiguration) {
            this.presenterOnlyConfiguration = presenterOnlyConfiguration;
            return this;
        }

        public final ActiveSpeakerOnlyConfiguration.Builder getActiveSpeakerOnlyConfiguration() {
            return this.activeSpeakerOnlyConfiguration != null ? this.activeSpeakerOnlyConfiguration.toBuilder() : null;
        }

        public final void setActiveSpeakerOnlyConfiguration(ActiveSpeakerOnlyConfiguration.BuilderImpl activeSpeakerOnlyConfiguration) {
            this.activeSpeakerOnlyConfiguration = activeSpeakerOnlyConfiguration != null ? activeSpeakerOnlyConfiguration.build() : null;
        }

        @Override
        public final Builder activeSpeakerOnlyConfiguration(ActiveSpeakerOnlyConfiguration activeSpeakerOnlyConfiguration) {
            this.activeSpeakerOnlyConfiguration = activeSpeakerOnlyConfiguration;
            return this;
        }

        public final HorizontalLayoutConfiguration.Builder getHorizontalLayoutConfiguration() {
            return this.horizontalLayoutConfiguration != null ? this.horizontalLayoutConfiguration.toBuilder() : null;
        }

        public final void setHorizontalLayoutConfiguration(HorizontalLayoutConfiguration.BuilderImpl horizontalLayoutConfiguration) {
            this.horizontalLayoutConfiguration = horizontalLayoutConfiguration != null ? horizontalLayoutConfiguration.build() : null;
        }

        @Override
        public final Builder horizontalLayoutConfiguration(HorizontalLayoutConfiguration horizontalLayoutConfiguration) {
            this.horizontalLayoutConfiguration = horizontalLayoutConfiguration;
            return this;
        }

        public final VerticalLayoutConfiguration.Builder getVerticalLayoutConfiguration() {
            return this.verticalLayoutConfiguration != null ? this.verticalLayoutConfiguration.toBuilder() : null;
        }

        public final void setVerticalLayoutConfiguration(VerticalLayoutConfiguration.BuilderImpl verticalLayoutConfiguration) {
            this.verticalLayoutConfiguration = verticalLayoutConfiguration != null ? verticalLayoutConfiguration.build() : null;
        }

        @Override
        public final Builder verticalLayoutConfiguration(VerticalLayoutConfiguration verticalLayoutConfiguration) {
            this.verticalLayoutConfiguration = verticalLayoutConfiguration;
            return this;
        }

        public final VideoAttribute.Builder getVideoAttribute() {
            return this.videoAttribute != null ? this.videoAttribute.toBuilder() : null;
        }

        public final void setVideoAttribute(VideoAttribute.BuilderImpl videoAttribute) {
            this.videoAttribute = videoAttribute != null ? videoAttribute.build() : null;
        }

        @Override
        public final Builder videoAttribute(VideoAttribute videoAttribute) {
            this.videoAttribute = videoAttribute;
            return this;
        }

        public final String getCanvasOrientation() {
            return this.canvasOrientation;
        }

        public final void setCanvasOrientation(String canvasOrientation) {
            this.canvasOrientation = canvasOrientation;
        }

        @Override
        public final Builder canvasOrientation(String canvasOrientation) {
            this.canvasOrientation = canvasOrientation;
            return this;
        }

        @Override
        public final Builder canvasOrientation(CanvasOrientation canvasOrientation) {
            this.canvasOrientation(canvasOrientation == null ? null : canvasOrientation.toString());
            return this;
        }

        public GridViewConfiguration build() {
            return new GridViewConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GridViewConfiguration> {
        public Builder contentShareLayout(String var1);

        public Builder contentShareLayout(ContentShareLayoutOption var1);

        public Builder presenterOnlyConfiguration(PresenterOnlyConfiguration var1);

        default public Builder presenterOnlyConfiguration(Consumer<PresenterOnlyConfiguration.Builder> presenterOnlyConfiguration) {
            return this.presenterOnlyConfiguration((PresenterOnlyConfiguration)((PresenterOnlyConfiguration.Builder)PresenterOnlyConfiguration.builder().applyMutation(presenterOnlyConfiguration)).build());
        }

        public Builder activeSpeakerOnlyConfiguration(ActiveSpeakerOnlyConfiguration var1);

        default public Builder activeSpeakerOnlyConfiguration(Consumer<ActiveSpeakerOnlyConfiguration.Builder> activeSpeakerOnlyConfiguration) {
            return this.activeSpeakerOnlyConfiguration((ActiveSpeakerOnlyConfiguration)((ActiveSpeakerOnlyConfiguration.Builder)ActiveSpeakerOnlyConfiguration.builder().applyMutation(activeSpeakerOnlyConfiguration)).build());
        }

        public Builder horizontalLayoutConfiguration(HorizontalLayoutConfiguration var1);

        default public Builder horizontalLayoutConfiguration(Consumer<HorizontalLayoutConfiguration.Builder> horizontalLayoutConfiguration) {
            return this.horizontalLayoutConfiguration((HorizontalLayoutConfiguration)((HorizontalLayoutConfiguration.Builder)HorizontalLayoutConfiguration.builder().applyMutation(horizontalLayoutConfiguration)).build());
        }

        public Builder verticalLayoutConfiguration(VerticalLayoutConfiguration var1);

        default public Builder verticalLayoutConfiguration(Consumer<VerticalLayoutConfiguration.Builder> verticalLayoutConfiguration) {
            return this.verticalLayoutConfiguration((VerticalLayoutConfiguration)((VerticalLayoutConfiguration.Builder)VerticalLayoutConfiguration.builder().applyMutation(verticalLayoutConfiguration)).build());
        }

        public Builder videoAttribute(VideoAttribute var1);

        default public Builder videoAttribute(Consumer<VideoAttribute.Builder> videoAttribute) {
            return this.videoAttribute((VideoAttribute)((VideoAttribute.Builder)VideoAttribute.builder().applyMutation(videoAttribute)).build());
        }

        public Builder canvasOrientation(String var1);

        public Builder canvasOrientation(CanvasOrientation var1);
    }
}

