/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.IssueDetectionConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KeywordMatchConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertRuleType;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.SentimentConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RealTimeAlertRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RealTimeAlertRule> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RealTimeAlertRule.getter(RealTimeAlertRule::typeAsString)).setter(RealTimeAlertRule.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<KeywordMatchConfiguration> KEYWORD_MATCH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeywordMatchConfiguration").getter(RealTimeAlertRule.getter(RealTimeAlertRule::keywordMatchConfiguration)).setter(RealTimeAlertRule.setter(Builder::keywordMatchConfiguration)).constructor(KeywordMatchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeywordMatchConfiguration").build()}).build();
    private static final SdkField<SentimentConfiguration> SENTIMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SentimentConfiguration").getter(RealTimeAlertRule.getter(RealTimeAlertRule::sentimentConfiguration)).setter(RealTimeAlertRule.setter(Builder::sentimentConfiguration)).constructor(SentimentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentConfiguration").build()}).build();
    private static final SdkField<IssueDetectionConfiguration> ISSUE_DETECTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IssueDetectionConfiguration").getter(RealTimeAlertRule.getter(RealTimeAlertRule::issueDetectionConfiguration)).setter(RealTimeAlertRule.setter(Builder::issueDetectionConfiguration)).constructor(IssueDetectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueDetectionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, KEYWORD_MATCH_CONFIGURATION_FIELD, SENTIMENT_CONFIGURATION_FIELD, ISSUE_DETECTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RealTimeAlertRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final KeywordMatchConfiguration keywordMatchConfiguration;
    private final SentimentConfiguration sentimentConfiguration;
    private final IssueDetectionConfiguration issueDetectionConfiguration;

    private RealTimeAlertRule(BuilderImpl builder) {
        this.type = builder.type;
        this.keywordMatchConfiguration = builder.keywordMatchConfiguration;
        this.sentimentConfiguration = builder.sentimentConfiguration;
        this.issueDetectionConfiguration = builder.issueDetectionConfiguration;
    }

    public final RealTimeAlertRuleType type() {
        return RealTimeAlertRuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final KeywordMatchConfiguration keywordMatchConfiguration() {
        return this.keywordMatchConfiguration;
    }

    public final SentimentConfiguration sentimentConfiguration() {
        return this.sentimentConfiguration;
    }

    public final IssueDetectionConfiguration issueDetectionConfiguration() {
        return this.issueDetectionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keywordMatchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.issueDetectionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeAlertRule)) {
            return false;
        }
        RealTimeAlertRule other = (RealTimeAlertRule)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.keywordMatchConfiguration(), other.keywordMatchConfiguration()) && Objects.equals(this.sentimentConfiguration(), other.sentimentConfiguration()) && Objects.equals(this.issueDetectionConfiguration(), other.issueDetectionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RealTimeAlertRule").add("Type", (Object)this.typeAsString()).add("KeywordMatchConfiguration", (Object)this.keywordMatchConfiguration()).add("SentimentConfiguration", (Object)this.sentimentConfiguration()).add("IssueDetectionConfiguration", (Object)this.issueDetectionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "KeywordMatchConfiguration": {
                return Optional.ofNullable(clazz.cast(this.keywordMatchConfiguration()));
            }
            case "SentimentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sentimentConfiguration()));
            }
            case "IssueDetectionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.issueDetectionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("KeywordMatchConfiguration", KEYWORD_MATCH_CONFIGURATION_FIELD);
        map.put("SentimentConfiguration", SENTIMENT_CONFIGURATION_FIELD);
        map.put("IssueDetectionConfiguration", ISSUE_DETECTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealTimeAlertRule, T> g) {
        return obj -> g.apply((RealTimeAlertRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private KeywordMatchConfiguration keywordMatchConfiguration;
        private SentimentConfiguration sentimentConfiguration;
        private IssueDetectionConfiguration issueDetectionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeAlertRule model) {
            this.type(model.type);
            this.keywordMatchConfiguration(model.keywordMatchConfiguration);
            this.sentimentConfiguration(model.sentimentConfiguration);
            this.issueDetectionConfiguration(model.issueDetectionConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RealTimeAlertRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final KeywordMatchConfiguration.Builder getKeywordMatchConfiguration() {
            return this.keywordMatchConfiguration != null ? this.keywordMatchConfiguration.toBuilder() : null;
        }

        public final void setKeywordMatchConfiguration(KeywordMatchConfiguration.BuilderImpl keywordMatchConfiguration) {
            this.keywordMatchConfiguration = keywordMatchConfiguration != null ? keywordMatchConfiguration.build() : null;
        }

        @Override
        public final Builder keywordMatchConfiguration(KeywordMatchConfiguration keywordMatchConfiguration) {
            this.keywordMatchConfiguration = keywordMatchConfiguration;
            return this;
        }

        public final SentimentConfiguration.Builder getSentimentConfiguration() {
            return this.sentimentConfiguration != null ? this.sentimentConfiguration.toBuilder() : null;
        }

        public final void setSentimentConfiguration(SentimentConfiguration.BuilderImpl sentimentConfiguration) {
            this.sentimentConfiguration = sentimentConfiguration != null ? sentimentConfiguration.build() : null;
        }

        @Override
        public final Builder sentimentConfiguration(SentimentConfiguration sentimentConfiguration) {
            this.sentimentConfiguration = sentimentConfiguration;
            return this;
        }

        public final IssueDetectionConfiguration.Builder getIssueDetectionConfiguration() {
            return this.issueDetectionConfiguration != null ? this.issueDetectionConfiguration.toBuilder() : null;
        }

        public final void setIssueDetectionConfiguration(IssueDetectionConfiguration.BuilderImpl issueDetectionConfiguration) {
            this.issueDetectionConfiguration = issueDetectionConfiguration != null ? issueDetectionConfiguration.build() : null;
        }

        @Override
        public final Builder issueDetectionConfiguration(IssueDetectionConfiguration issueDetectionConfiguration) {
            this.issueDetectionConfiguration = issueDetectionConfiguration;
            return this;
        }

        public RealTimeAlertRule build() {
            return new RealTimeAlertRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RealTimeAlertRule> {
        public Builder type(String var1);

        public Builder type(RealTimeAlertRuleType var1);

        public Builder keywordMatchConfiguration(KeywordMatchConfiguration var1);

        default public Builder keywordMatchConfiguration(Consumer<KeywordMatchConfiguration.Builder> keywordMatchConfiguration) {
            return this.keywordMatchConfiguration((KeywordMatchConfiguration)((KeywordMatchConfiguration.Builder)KeywordMatchConfiguration.builder().applyMutation(keywordMatchConfiguration)).build());
        }

        public Builder sentimentConfiguration(SentimentConfiguration var1);

        default public Builder sentimentConfiguration(Consumer<SentimentConfiguration.Builder> sentimentConfiguration) {
            return this.sentimentConfiguration((SentimentConfiguration)((SentimentConfiguration.Builder)SentimentConfiguration.builder().applyMutation(sentimentConfiguration)).build());
        }

        public Builder issueDetectionConfiguration(IssueDetectionConfiguration var1);

        default public Builder issueDetectionConfiguration(Consumer<IssueDetectionConfiguration.Builder> issueDetectionConfiguration) {
            return this.issueDetectionConfiguration((IssueDetectionConfiguration)((IssueDetectionConfiguration.Builder)IssueDetectionConfiguration.builder().applyMutation(issueDetectionConfiguration)).build());
        }
    }
}

