/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudcontrol.model.Operation;
import software.amazon.awssdk.services.cloudcontrol.model.OperationStatus;
import software.amazon.awssdk.services.cloudcontrol.model.OperationStatusesCopier;
import software.amazon.awssdk.services.cloudcontrol.model.OperationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceRequestStatusFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceRequestStatusFilter> {
    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Operations").getter(ResourceRequestStatusFilter.getter(ResourceRequestStatusFilter::operationsAsStrings)).setter(ResourceRequestStatusFilter.setter(Builder::operationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OPERATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperationStatuses").getter(ResourceRequestStatusFilter.getter(ResourceRequestStatusFilter::operationStatusesAsStrings)).setter(ResourceRequestStatusFilter.setter(Builder::operationStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATIONS_FIELD, OPERATION_STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceRequestStatusFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> operations;
    private final List<String> operationStatuses;

    private ResourceRequestStatusFilter(BuilderImpl builder) {
        this.operations = builder.operations;
        this.operationStatuses = builder.operationStatuses;
    }

    public final List<Operation> operations() {
        return OperationsCopier.copyStringToEnum(this.operations);
    }

    public final boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public final List<String> operationsAsStrings() {
        return this.operations;
    }

    public final List<OperationStatus> operationStatuses() {
        return OperationStatusesCopier.copyStringToEnum(this.operationStatuses);
    }

    public final boolean hasOperationStatuses() {
        return this.operationStatuses != null && !(this.operationStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> operationStatusesAsStrings() {
        return this.operationStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperations() ? this.operationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationStatuses() ? this.operationStatusesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceRequestStatusFilter)) {
            return false;
        }
        ResourceRequestStatusFilter other = (ResourceRequestStatusFilter)obj;
        return this.hasOperations() == other.hasOperations() && Objects.equals(this.operationsAsStrings(), other.operationsAsStrings()) && this.hasOperationStatuses() == other.hasOperationStatuses() && Objects.equals(this.operationStatusesAsStrings(), other.operationStatusesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceRequestStatusFilter").add("Operations", this.hasOperations() ? this.operationsAsStrings() : null).add("OperationStatuses", this.hasOperationStatuses() ? this.operationStatusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operations": {
                return Optional.ofNullable(clazz.cast(this.operationsAsStrings()));
            }
            case "OperationStatuses": {
                return Optional.ofNullable(clazz.cast(this.operationStatusesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Operations", OPERATIONS_FIELD);
        map.put("OperationStatuses", OPERATION_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceRequestStatusFilter, T> g) {
        return obj -> g.apply((ResourceRequestStatusFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> operations = DefaultSdkAutoConstructList.getInstance();
        private List<String> operationStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceRequestStatusFilter model) {
            this.operationsWithStrings(model.operations);
            this.operationStatusesWithStrings(model.operationStatuses);
        }

        public final Collection<String> getOperations() {
            if (this.operations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operations;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = OperationsCopier.copy(operations);
        }

        @Override
        public final Builder operationsWithStrings(Collection<String> operations) {
            this.operations = OperationsCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationsWithStrings(String ... operations) {
            this.operationsWithStrings(Arrays.asList(operations));
            return this;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationsCopier.copyEnumToString(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final Collection<String> getOperationStatuses() {
            if (this.operationStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operationStatuses;
        }

        public final void setOperationStatuses(Collection<String> operationStatuses) {
            this.operationStatuses = OperationStatusesCopier.copy(operationStatuses);
        }

        @Override
        public final Builder operationStatusesWithStrings(Collection<String> operationStatuses) {
            this.operationStatuses = OperationStatusesCopier.copy(operationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationStatusesWithStrings(String ... operationStatuses) {
            this.operationStatusesWithStrings(Arrays.asList(operationStatuses));
            return this;
        }

        @Override
        public final Builder operationStatuses(Collection<OperationStatus> operationStatuses) {
            this.operationStatuses = OperationStatusesCopier.copyEnumToString(operationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationStatuses(OperationStatus ... operationStatuses) {
            this.operationStatuses(Arrays.asList(operationStatuses));
            return this;
        }

        public ResourceRequestStatusFilter build() {
            return new ResourceRequestStatusFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceRequestStatusFilter> {
        public Builder operationsWithStrings(Collection<String> var1);

        public Builder operationsWithStrings(String ... var1);

        public Builder operations(Collection<Operation> var1);

        public Builder operations(Operation ... var1);

        public Builder operationStatusesWithStrings(Collection<String> var1);

        public Builder operationStatusesWithStrings(String ... var1);

        public Builder operationStatuses(Collection<OperationStatus> var1);

        public Builder operationStatuses(OperationStatus ... var1);
    }
}

