/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddFacetToObjectRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, AddFacetToObjectRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(AddFacetToObjectRequest.getter(AddFacetToObjectRequest::directoryArn)).setter(AddFacetToObjectRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<SchemaFacet> SCHEMA_FACET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaFacet").getter(AddFacetToObjectRequest.getter(AddFacetToObjectRequest::schemaFacet)).setter(AddFacetToObjectRequest.setter(Builder::schemaFacet)).constructor(SchemaFacet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaFacet").build()}).build();
    private static final SdkField<List<AttributeKeyAndValue>> OBJECT_ATTRIBUTE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ObjectAttributeList").getter(AddFacetToObjectRequest.getter(AddFacetToObjectRequest::objectAttributeList)).setter(AddFacetToObjectRequest.setter(Builder::objectAttributeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectAttributeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeKeyAndValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ObjectReference").getter(AddFacetToObjectRequest.getter(AddFacetToObjectRequest::objectReference)).setter(AddFacetToObjectRequest.setter(Builder::objectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, SCHEMA_FACET_FIELD, OBJECT_ATTRIBUTE_LIST_FIELD, OBJECT_REFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddFacetToObjectRequest.memberNameToFieldInitializer();
    private final String directoryArn;
    private final SchemaFacet schemaFacet;
    private final List<AttributeKeyAndValue> objectAttributeList;
    private final ObjectReference objectReference;

    private AddFacetToObjectRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.schemaFacet = builder.schemaFacet;
        this.objectAttributeList = builder.objectAttributeList;
        this.objectReference = builder.objectReference;
    }

    public final String directoryArn() {
        return this.directoryArn;
    }

    public final SchemaFacet schemaFacet() {
        return this.schemaFacet;
    }

    public final boolean hasObjectAttributeList() {
        return this.objectAttributeList != null && !(this.objectAttributeList instanceof SdkAutoConstructList);
    }

    public final List<AttributeKeyAndValue> objectAttributeList() {
        return this.objectAttributeList;
    }

    public final ObjectReference objectReference() {
        return this.objectReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaFacet());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectAttributeList() ? this.objectAttributeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFacetToObjectRequest)) {
            return false;
        }
        AddFacetToObjectRequest other = (AddFacetToObjectRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.schemaFacet(), other.schemaFacet()) && this.hasObjectAttributeList() == other.hasObjectAttributeList() && Objects.equals(this.objectAttributeList(), other.objectAttributeList()) && Objects.equals(this.objectReference(), other.objectReference());
    }

    public final String toString() {
        return ToString.builder((String)"AddFacetToObjectRequest").add("DirectoryArn", (Object)this.directoryArn()).add("SchemaFacet", (Object)this.schemaFacet()).add("ObjectAttributeList", this.hasObjectAttributeList() ? this.objectAttributeList() : null).add("ObjectReference", (Object)this.objectReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "SchemaFacet": {
                return Optional.ofNullable(clazz.cast(this.schemaFacet()));
            }
            case "ObjectAttributeList": {
                return Optional.ofNullable(clazz.cast(this.objectAttributeList()));
            }
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x-amz-data-partition", DIRECTORY_ARN_FIELD);
        map.put("SchemaFacet", SCHEMA_FACET_FIELD);
        map.put("ObjectAttributeList", OBJECT_ATTRIBUTE_LIST_FIELD);
        map.put("ObjectReference", OBJECT_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddFacetToObjectRequest, T> g) {
        return obj -> g.apply((AddFacetToObjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private SchemaFacet schemaFacet;
        private List<AttributeKeyAndValue> objectAttributeList = DefaultSdkAutoConstructList.getInstance();
        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(AddFacetToObjectRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.schemaFacet(model.schemaFacet);
            this.objectAttributeList(model.objectAttributeList);
            this.objectReference(model.objectReference);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final SchemaFacet.Builder getSchemaFacet() {
            return this.schemaFacet != null ? this.schemaFacet.toBuilder() : null;
        }

        public final void setSchemaFacet(SchemaFacet.BuilderImpl schemaFacet) {
            this.schemaFacet = schemaFacet != null ? schemaFacet.build() : null;
        }

        @Override
        public final Builder schemaFacet(SchemaFacet schemaFacet) {
            this.schemaFacet = schemaFacet;
            return this;
        }

        public final List<AttributeKeyAndValue.Builder> getObjectAttributeList() {
            List<AttributeKeyAndValue.Builder> result = AttributeKeyAndValueListCopier.copyToBuilder(this.objectAttributeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue.BuilderImpl> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copyFromBuilder(objectAttributeList);
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
            this.objectAttributeList(Arrays.asList(objectAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder> ... objectAttributeList) {
            this.objectAttributeList(Stream.of(objectAttributeList).map(c -> (AttributeKeyAndValue)((AttributeKeyAndValue.Builder)AttributeKeyAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddFacetToObjectRequest build() {
            return new AddFacetToObjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddFacetToObjectRequest> {
        public Builder directoryArn(String var1);

        public Builder schemaFacet(SchemaFacet var1);

        default public Builder schemaFacet(Consumer<SchemaFacet.Builder> schemaFacet) {
            return this.schemaFacet((SchemaFacet)((SchemaFacet.Builder)SchemaFacet.builder().applyMutation(schemaFacet)).build());
        }

        public Builder objectAttributeList(Collection<AttributeKeyAndValue> var1);

        public Builder objectAttributeList(AttributeKeyAndValue ... var1);

        public Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder> ... var1);

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

