/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.internal.UserAgentUtils;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse;

public class ListIndexPublisher
implements SdkPublisher<ListIndexResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListIndexRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIndexPublisher(CloudDirectoryAsyncClient client, ListIndexRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIndexPublisher(CloudDirectoryAsyncClient client, ListIndexRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIndexResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIndexResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListIndexResponseFetcher
    implements AsyncPageFetcher<ListIndexResponse> {
        private ListIndexResponseFetcher() {
        }

        public boolean hasNextPage(ListIndexResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIndexResponse> nextPage(ListIndexResponse previousPage) {
            if (previousPage == null) {
                return ListIndexPublisher.this.client.listIndex(ListIndexPublisher.this.firstRequest);
            }
            return ListIndexPublisher.this.client.listIndex((ListIndexRequest)((Object)ListIndexPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

