/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.internal.UserAgentUtils;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse;

public class ListObjectChildrenIterable
implements SdkIterable<ListObjectChildrenResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectChildrenRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObjectChildrenIterable(CloudDirectoryClient client, ListObjectChildrenRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListObjectChildrenResponseFetcher();
    }

    public Iterator<ListObjectChildrenResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListObjectChildrenResponseFetcher
    implements SyncPageFetcher<ListObjectChildrenResponse> {
        private ListObjectChildrenResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectChildrenResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListObjectChildrenResponse nextPage(ListObjectChildrenResponse previousPage) {
            if (previousPage == null) {
                return ListObjectChildrenIterable.this.client.listObjectChildren(ListObjectChildrenIterable.this.firstRequest);
            }
            return ListObjectChildrenIterable.this.client.listObjectChildren((ListObjectChildrenRequest)((Object)ListObjectChildrenIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

