/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByTrustStoreRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByTrustStoreResponse;

public class ListDistributionsByTrustStoreIterable
implements SdkIterable<ListDistributionsByTrustStoreResponse> {
    private final CloudFrontClient client;
    private final ListDistributionsByTrustStoreRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDistributionsByTrustStoreIterable(CloudFrontClient client, ListDistributionsByTrustStoreRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDistributionsByTrustStoreResponseFetcher();
    }

    public Iterator<ListDistributionsByTrustStoreResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DistributionSummary> items() {
        Function<ListDistributionsByTrustStoreResponse, Iterator> getIterator = response -> {
            if (response != null && response.distributionList() != null && response.distributionList().items() != null) {
                return response.distributionList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDistributionsByTrustStoreResponseFetcher
    implements SyncPageFetcher<ListDistributionsByTrustStoreResponse> {
        private ListDistributionsByTrustStoreResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionsByTrustStoreResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.distributionList().nextMarker());
        }

        public ListDistributionsByTrustStoreResponse nextPage(ListDistributionsByTrustStoreResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionsByTrustStoreIterable.this.client.listDistributionsByTrustStore(ListDistributionsByTrustStoreIterable.this.firstRequest);
            }
            return ListDistributionsByTrustStoreIterable.this.client.listDistributionsByTrustStore((ListDistributionsByTrustStoreRequest)((Object)ListDistributionsByTrustStoreIterable.this.firstRequest.toBuilder().marker(previousPage.distributionList().nextMarker()).build()));
        }
    }
}

