/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.DeleteFileEntriesCopier;
import software.amazon.awssdk.services.codecommit.model.DeleteFileEntry;
import software.amazon.awssdk.services.codecommit.model.ReplaceContentEntriesCopier;
import software.amazon.awssdk.services.codecommit.model.ReplaceContentEntry;
import software.amazon.awssdk.services.codecommit.model.SetFileModeEntriesCopier;
import software.amazon.awssdk.services.codecommit.model.SetFileModeEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConflictResolution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConflictResolution> {
    private static final SdkField<List<ReplaceContentEntry>> REPLACE_CONTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replaceContents").getter(ConflictResolution.getter(ConflictResolution::replaceContents)).setter(ConflictResolution.setter(Builder::replaceContents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replaceContents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplaceContentEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DeleteFileEntry>> DELETE_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deleteFiles").getter(ConflictResolution.getter(ConflictResolution::deleteFiles)).setter(ConflictResolution.setter(Builder::deleteFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteFileEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SetFileModeEntry>> SET_FILE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("setFileModes").getter(ConflictResolution.getter(ConflictResolution::setFileModes)).setter(ConflictResolution.setter(Builder::setFileModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setFileModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SetFileModeEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACE_CONTENTS_FIELD, DELETE_FILES_FIELD, SET_FILE_MODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConflictResolution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ReplaceContentEntry> replaceContents;
    private final List<DeleteFileEntry> deleteFiles;
    private final List<SetFileModeEntry> setFileModes;

    private ConflictResolution(BuilderImpl builder) {
        this.replaceContents = builder.replaceContents;
        this.deleteFiles = builder.deleteFiles;
        this.setFileModes = builder.setFileModes;
    }

    public final boolean hasReplaceContents() {
        return this.replaceContents != null && !(this.replaceContents instanceof SdkAutoConstructList);
    }

    public final List<ReplaceContentEntry> replaceContents() {
        return this.replaceContents;
    }

    public final boolean hasDeleteFiles() {
        return this.deleteFiles != null && !(this.deleteFiles instanceof SdkAutoConstructList);
    }

    public final List<DeleteFileEntry> deleteFiles() {
        return this.deleteFiles;
    }

    public final boolean hasSetFileModes() {
        return this.setFileModes != null && !(this.setFileModes instanceof SdkAutoConstructList);
    }

    public final List<SetFileModeEntry> setFileModes() {
        return this.setFileModes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplaceContents() ? this.replaceContents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeleteFiles() ? this.deleteFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSetFileModes() ? this.setFileModes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictResolution)) {
            return false;
        }
        ConflictResolution other = (ConflictResolution)obj;
        return this.hasReplaceContents() == other.hasReplaceContents() && Objects.equals(this.replaceContents(), other.replaceContents()) && this.hasDeleteFiles() == other.hasDeleteFiles() && Objects.equals(this.deleteFiles(), other.deleteFiles()) && this.hasSetFileModes() == other.hasSetFileModes() && Objects.equals(this.setFileModes(), other.setFileModes());
    }

    public final String toString() {
        return ToString.builder((String)"ConflictResolution").add("ReplaceContents", this.hasReplaceContents() ? this.replaceContents() : null).add("DeleteFiles", this.hasDeleteFiles() ? this.deleteFiles() : null).add("SetFileModes", this.hasSetFileModes() ? this.setFileModes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replaceContents": {
                return Optional.ofNullable(clazz.cast(this.replaceContents()));
            }
            case "deleteFiles": {
                return Optional.ofNullable(clazz.cast(this.deleteFiles()));
            }
            case "setFileModes": {
                return Optional.ofNullable(clazz.cast(this.setFileModes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("replaceContents", REPLACE_CONTENTS_FIELD);
        map.put("deleteFiles", DELETE_FILES_FIELD);
        map.put("setFileModes", SET_FILE_MODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConflictResolution, T> g) {
        return obj -> g.apply((ConflictResolution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ReplaceContentEntry> replaceContents = DefaultSdkAutoConstructList.getInstance();
        private List<DeleteFileEntry> deleteFiles = DefaultSdkAutoConstructList.getInstance();
        private List<SetFileModeEntry> setFileModes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictResolution model) {
            this.replaceContents(model.replaceContents);
            this.deleteFiles(model.deleteFiles);
            this.setFileModes(model.setFileModes);
        }

        public final List<ReplaceContentEntry.Builder> getReplaceContents() {
            List<ReplaceContentEntry.Builder> result = ReplaceContentEntriesCopier.copyToBuilder(this.replaceContents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplaceContents(Collection<ReplaceContentEntry.BuilderImpl> replaceContents) {
            this.replaceContents = ReplaceContentEntriesCopier.copyFromBuilder(replaceContents);
        }

        @Override
        public final Builder replaceContents(Collection<ReplaceContentEntry> replaceContents) {
            this.replaceContents = ReplaceContentEntriesCopier.copy(replaceContents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replaceContents(ReplaceContentEntry ... replaceContents) {
            this.replaceContents(Arrays.asList(replaceContents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replaceContents(Consumer<ReplaceContentEntry.Builder> ... replaceContents) {
            this.replaceContents(Stream.of(replaceContents).map(c -> (ReplaceContentEntry)((ReplaceContentEntry.Builder)ReplaceContentEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DeleteFileEntry.Builder> getDeleteFiles() {
            List<DeleteFileEntry.Builder> result = DeleteFileEntriesCopier.copyToBuilder(this.deleteFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeleteFiles(Collection<DeleteFileEntry.BuilderImpl> deleteFiles) {
            this.deleteFiles = DeleteFileEntriesCopier.copyFromBuilder(deleteFiles);
        }

        @Override
        public final Builder deleteFiles(Collection<DeleteFileEntry> deleteFiles) {
            this.deleteFiles = DeleteFileEntriesCopier.copy(deleteFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteFiles(DeleteFileEntry ... deleteFiles) {
            this.deleteFiles(Arrays.asList(deleteFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteFiles(Consumer<DeleteFileEntry.Builder> ... deleteFiles) {
            this.deleteFiles(Stream.of(deleteFiles).map(c -> (DeleteFileEntry)((DeleteFileEntry.Builder)DeleteFileEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SetFileModeEntry.Builder> getSetFileModes() {
            List<SetFileModeEntry.Builder> result = SetFileModeEntriesCopier.copyToBuilder(this.setFileModes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSetFileModes(Collection<SetFileModeEntry.BuilderImpl> setFileModes) {
            this.setFileModes = SetFileModeEntriesCopier.copyFromBuilder(setFileModes);
        }

        @Override
        @Transient
        public final Builder setFileModes(Collection<SetFileModeEntry> setFileModes) {
            this.setFileModes = SetFileModeEntriesCopier.copy(setFileModes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder setFileModes(SetFileModeEntry ... setFileModes) {
            this.setFileModes(Arrays.asList(setFileModes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder setFileModes(Consumer<SetFileModeEntry.Builder> ... setFileModes) {
            this.setFileModes(Stream.of(setFileModes).map(c -> (SetFileModeEntry)((SetFileModeEntry.Builder)SetFileModeEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConflictResolution build() {
            return new ConflictResolution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConflictResolution> {
        public Builder replaceContents(Collection<ReplaceContentEntry> var1);

        public Builder replaceContents(ReplaceContentEntry ... var1);

        public Builder replaceContents(Consumer<ReplaceContentEntry.Builder> ... var1);

        public Builder deleteFiles(Collection<DeleteFileEntry> var1);

        public Builder deleteFiles(DeleteFileEntry ... var1);

        public Builder deleteFiles(Consumer<DeleteFileEntry.Builder> ... var1);

        public Builder setFileModes(Collection<SetFileModeEntry> var1);

        public Builder setFileModes(SetFileModeEntry ... var1);

        public Builder setFileModes(Consumer<SetFileModeEntry.Builder> ... var1);
    }
}

