/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.FileVersion;
import software.amazon.awssdk.services.codecommit.model.RevisionDagCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFileCommitHistoryResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, ListFileCommitHistoryResponse> {
    private static final SdkField<List<FileVersion>> REVISION_DAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("revisionDag").getter(ListFileCommitHistoryResponse.getter(ListFileCommitHistoryResponse::revisionDag)).setter(ListFileCommitHistoryResponse.setter(Builder::revisionDag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionDag").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFileCommitHistoryResponse.getter(ListFileCommitHistoryResponse::nextToken)).setter(ListFileCommitHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_DAG_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFileCommitHistoryResponse.memberNameToFieldInitializer();
    private final List<FileVersion> revisionDag;
    private final String nextToken;

    private ListFileCommitHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.revisionDag = builder.revisionDag;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRevisionDag() {
        return this.revisionDag != null && !(this.revisionDag instanceof SdkAutoConstructList);
    }

    public final List<FileVersion> revisionDag() {
        return this.revisionDag;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevisionDag() ? this.revisionDag() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileCommitHistoryResponse)) {
            return false;
        }
        ListFileCommitHistoryResponse other = (ListFileCommitHistoryResponse)((Object)obj);
        return this.hasRevisionDag() == other.hasRevisionDag() && Objects.equals(this.revisionDag(), other.revisionDag()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFileCommitHistoryResponse").add("RevisionDag", this.hasRevisionDag() ? this.revisionDag() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revisionDag": {
                return Optional.ofNullable(clazz.cast(this.revisionDag()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("revisionDag", REVISION_DAG_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFileCommitHistoryResponse, T> g) {
        return obj -> g.apply((ListFileCommitHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<FileVersion> revisionDag = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFileCommitHistoryResponse model) {
            super(model);
            this.revisionDag(model.revisionDag);
            this.nextToken(model.nextToken);
        }

        public final List<FileVersion.Builder> getRevisionDag() {
            List<FileVersion.Builder> result = RevisionDagCopier.copyToBuilder(this.revisionDag);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevisionDag(Collection<FileVersion.BuilderImpl> revisionDag) {
            this.revisionDag = RevisionDagCopier.copyFromBuilder(revisionDag);
        }

        @Override
        public final Builder revisionDag(Collection<FileVersion> revisionDag) {
            this.revisionDag = RevisionDagCopier.copy(revisionDag);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDag(FileVersion ... revisionDag) {
            this.revisionDag(Arrays.asList(revisionDag));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDag(Consumer<FileVersion.Builder> ... revisionDag) {
            this.revisionDag(Stream.of(revisionDag).map(c -> (FileVersion)((FileVersion.Builder)FileVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFileCommitHistoryResponse build() {
            return new ListFileCommitHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFileCommitHistoryResponse> {
        public Builder revisionDag(Collection<FileVersion> var1);

        public Builder revisionDag(FileVersion ... var1);

        public Builder revisionDag(Consumer<FileVersion.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

