/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityAsyncClientBuilder;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityServiceClientConfiguration;
import software.amazon.awssdk.services.codegurusecurity.DefaultCodeGuruSecurityAsyncClientBuilder;
import software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.CreateScanRequest;
import software.amazon.awssdk.services.codegurusecurity.model.CreateScanResponse;
import software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlRequest;
import software.amazon.awssdk.services.codegurusecurity.model.CreateUploadUrlResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetAccountConfigurationResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryResponse;
import software.amazon.awssdk.services.codegurusecurity.model.GetScanRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetScanResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListScansResponse;
import software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.TagResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.TagResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.UntagResourceRequest;
import software.amazon.awssdk.services.codegurusecurity.model.UntagResourceResponse;
import software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationRequest;
import software.amazon.awssdk.services.codegurusecurity.model.UpdateAccountConfigurationResponse;
import software.amazon.awssdk.services.codegurusecurity.paginators.GetFindingsPublisher;
import software.amazon.awssdk.services.codegurusecurity.paginators.ListFindingsMetricsPublisher;
import software.amazon.awssdk.services.codegurusecurity.paginators.ListScansPublisher;

@SdkPublicApi
@ThreadSafe
public interface CodeGuruSecurityAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "codeguru-security";
    public static final String SERVICE_METADATA_ID = "codeguru-security";

    default public CompletableFuture<BatchGetFindingsResponse> batchGetFindings(BatchGetFindingsRequest batchGetFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<BatchGetFindingsResponse> batchGetFindings(Consumer<BatchGetFindingsRequest.Builder> batchGetFindingsRequest) {
        return this.batchGetFindings((BatchGetFindingsRequest)((Object)((BatchGetFindingsRequest.Builder)BatchGetFindingsRequest.builder().applyMutation(batchGetFindingsRequest)).build()));
    }

    default public CompletableFuture<CreateScanResponse> createScan(CreateScanRequest createScanRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateScanResponse> createScan(Consumer<CreateScanRequest.Builder> createScanRequest) {
        return this.createScan((CreateScanRequest)((Object)((CreateScanRequest.Builder)CreateScanRequest.builder().applyMutation(createScanRequest)).build()));
    }

    default public CompletableFuture<CreateUploadUrlResponse> createUploadUrl(CreateUploadUrlRequest createUploadUrlRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateUploadUrlResponse> createUploadUrl(Consumer<CreateUploadUrlRequest.Builder> createUploadUrlRequest) {
        return this.createUploadUrl((CreateUploadUrlRequest)((Object)((CreateUploadUrlRequest.Builder)CreateUploadUrlRequest.builder().applyMutation(createUploadUrlRequest)).build()));
    }

    default public CompletableFuture<GetAccountConfigurationResponse> getAccountConfiguration(GetAccountConfigurationRequest getAccountConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetAccountConfigurationResponse> getAccountConfiguration(Consumer<GetAccountConfigurationRequest.Builder> getAccountConfigurationRequest) {
        return this.getAccountConfiguration((GetAccountConfigurationRequest)((Object)((GetAccountConfigurationRequest.Builder)GetAccountConfigurationRequest.builder().applyMutation(getAccountConfigurationRequest)).build()));
    }

    default public CompletableFuture<GetFindingsResponse> getFindings(GetFindingsRequest getFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetFindingsResponse> getFindings(Consumer<GetFindingsRequest.Builder> getFindingsRequest) {
        return this.getFindings((GetFindingsRequest)((Object)((GetFindingsRequest.Builder)GetFindingsRequest.builder().applyMutation(getFindingsRequest)).build()));
    }

    default public GetFindingsPublisher getFindingsPaginator(GetFindingsRequest getFindingsRequest) {
        return new GetFindingsPublisher(this, getFindingsRequest);
    }

    default public GetFindingsPublisher getFindingsPaginator(Consumer<GetFindingsRequest.Builder> getFindingsRequest) {
        return this.getFindingsPaginator((GetFindingsRequest)((Object)((GetFindingsRequest.Builder)GetFindingsRequest.builder().applyMutation(getFindingsRequest)).build()));
    }

    default public CompletableFuture<GetMetricsSummaryResponse> getMetricsSummary(GetMetricsSummaryRequest getMetricsSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetMetricsSummaryResponse> getMetricsSummary(Consumer<GetMetricsSummaryRequest.Builder> getMetricsSummaryRequest) {
        return this.getMetricsSummary((GetMetricsSummaryRequest)((Object)((GetMetricsSummaryRequest.Builder)GetMetricsSummaryRequest.builder().applyMutation(getMetricsSummaryRequest)).build()));
    }

    default public CompletableFuture<GetScanResponse> getScan(GetScanRequest getScanRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetScanResponse> getScan(Consumer<GetScanRequest.Builder> getScanRequest) {
        return this.getScan((GetScanRequest)((Object)((GetScanRequest.Builder)GetScanRequest.builder().applyMutation(getScanRequest)).build()));
    }

    default public CompletableFuture<ListFindingsMetricsResponse> listFindingsMetrics(ListFindingsMetricsRequest listFindingsMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListFindingsMetricsResponse> listFindingsMetrics(Consumer<ListFindingsMetricsRequest.Builder> listFindingsMetricsRequest) {
        return this.listFindingsMetrics((ListFindingsMetricsRequest)((Object)((ListFindingsMetricsRequest.Builder)ListFindingsMetricsRequest.builder().applyMutation(listFindingsMetricsRequest)).build()));
    }

    default public ListFindingsMetricsPublisher listFindingsMetricsPaginator(ListFindingsMetricsRequest listFindingsMetricsRequest) {
        return new ListFindingsMetricsPublisher(this, listFindingsMetricsRequest);
    }

    default public ListFindingsMetricsPublisher listFindingsMetricsPaginator(Consumer<ListFindingsMetricsRequest.Builder> listFindingsMetricsRequest) {
        return this.listFindingsMetricsPaginator((ListFindingsMetricsRequest)((Object)((ListFindingsMetricsRequest.Builder)ListFindingsMetricsRequest.builder().applyMutation(listFindingsMetricsRequest)).build()));
    }

    default public CompletableFuture<ListScansResponse> listScans(ListScansRequest listScansRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListScansResponse> listScans(Consumer<ListScansRequest.Builder> listScansRequest) {
        return this.listScans((ListScansRequest)((Object)((ListScansRequest.Builder)ListScansRequest.builder().applyMutation(listScansRequest)).build()));
    }

    default public ListScansPublisher listScansPaginator(ListScansRequest listScansRequest) {
        return new ListScansPublisher(this, listScansRequest);
    }

    default public ListScansPublisher listScansPaginator(Consumer<ListScansRequest.Builder> listScansRequest) {
        return this.listScansPaginator((ListScansRequest)((Object)((ListScansRequest.Builder)ListScansRequest.builder().applyMutation(listScansRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdateAccountConfigurationResponse> updateAccountConfiguration(UpdateAccountConfigurationRequest updateAccountConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateAccountConfigurationResponse> updateAccountConfiguration(Consumer<UpdateAccountConfigurationRequest.Builder> updateAccountConfigurationRequest) {
        return this.updateAccountConfiguration((UpdateAccountConfigurationRequest)((Object)((UpdateAccountConfigurationRequest.Builder)UpdateAccountConfigurationRequest.builder().applyMutation(updateAccountConfigurationRequest)).build()));
    }

    default public CodeGuruSecurityServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static CodeGuruSecurityAsyncClient create() {
        return (CodeGuruSecurityAsyncClient)CodeGuruSecurityAsyncClient.builder().build();
    }

    public static CodeGuruSecurityAsyncClientBuilder builder() {
        return new DefaultCodeGuruSecurityAsyncClientBuilder();
    }
}

