/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.MemorySizeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerConfiguration> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(ContainerConfiguration.getter(ContainerConfiguration::containerName)).setter(ContainerConfiguration.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<MemorySizeConfiguration> MEMORY_SIZE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memorySizeConfiguration").getter(ContainerConfiguration.getter(ContainerConfiguration::memorySizeConfiguration)).setter(ContainerConfiguration.setter(Builder::memorySizeConfiguration)).constructor(MemorySizeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeConfiguration").build()}).build();
    private static final SdkField<Integer> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpu").getter(ContainerConfiguration.getter(ContainerConfiguration::cpu)).setter(ContainerConfiguration.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, MEMORY_SIZE_CONFIGURATION_FIELD, CPU_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String containerName;
    private final MemorySizeConfiguration memorySizeConfiguration;
    private final Integer cpu;

    private ContainerConfiguration(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.memorySizeConfiguration = builder.memorySizeConfiguration;
        this.cpu = builder.cpu;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final MemorySizeConfiguration memorySizeConfiguration() {
        return this.memorySizeConfiguration;
    }

    public final Integer cpu() {
        return this.cpu;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerConfiguration)) {
            return false;
        }
        ContainerConfiguration other = (ContainerConfiguration)obj;
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.memorySizeConfiguration(), other.memorySizeConfiguration()) && Objects.equals(this.cpu(), other.cpu());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerConfiguration").add("ContainerName", (Object)this.containerName()).add("MemorySizeConfiguration", (Object)this.memorySizeConfiguration()).add("Cpu", (Object)this.cpu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "memorySizeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.memorySizeConfiguration()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("containerName", CONTAINER_NAME_FIELD);
        map.put("memorySizeConfiguration", MEMORY_SIZE_CONFIGURATION_FIELD);
        map.put("cpu", CPU_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerConfiguration, T> g) {
        return obj -> g.apply((ContainerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerName;
        private MemorySizeConfiguration memorySizeConfiguration;
        private Integer cpu;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerConfiguration model) {
            this.containerName(model.containerName);
            this.memorySizeConfiguration(model.memorySizeConfiguration);
            this.cpu(model.cpu);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final MemorySizeConfiguration.Builder getMemorySizeConfiguration() {
            return this.memorySizeConfiguration != null ? this.memorySizeConfiguration.toBuilder() : null;
        }

        public final void setMemorySizeConfiguration(MemorySizeConfiguration.BuilderImpl memorySizeConfiguration) {
            this.memorySizeConfiguration = memorySizeConfiguration != null ? memorySizeConfiguration.build() : null;
        }

        @Override
        public final Builder memorySizeConfiguration(MemorySizeConfiguration memorySizeConfiguration) {
            this.memorySizeConfiguration = memorySizeConfiguration;
            return this;
        }

        public final Integer getCpu() {
            return this.cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public ContainerConfiguration build() {
            return new ContainerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerConfiguration> {
        public Builder containerName(String var1);

        public Builder memorySizeConfiguration(MemorySizeConfiguration var1);

        default public Builder memorySizeConfiguration(Consumer<MemorySizeConfiguration.Builder> memorySizeConfiguration) {
            return this.memorySizeConfiguration((MemorySizeConfiguration)((MemorySizeConfiguration.Builder)MemorySizeConfiguration.builder().applyMutation(memorySizeConfiguration)).build());
        }

        public Builder cpu(Integer var1);
    }
}

