/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Finding {
    UNDERPROVISIONED("Underprovisioned"),
    OVERPROVISIONED("Overprovisioned"),
    OPTIMIZED("Optimized"),
    NOT_OPTIMIZED("NotOptimized"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Finding> VALUE_MAP;
    private final String value;

    private Finding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Finding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Finding> knownValues() {
        EnumSet<Finding> knownValues = EnumSet.allOf(Finding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Finding.class, Finding::toString);
    }
}

