/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.IdleFinding;
import software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationResourceType;
import software.amazon.awssdk.services.computeoptimizer.model.IdleSavingsOpportunity;
import software.amazon.awssdk.services.computeoptimizer.model.IdleSavingsOpportunityAfterDiscounts;
import software.amazon.awssdk.services.computeoptimizer.model.IdleUtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.IdleUtilizationMetricsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.Tag;
import software.amazon.awssdk.services.computeoptimizer.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdleRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdleRecommendation> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(IdleRecommendation.getter(IdleRecommendation::resourceArn)).setter(IdleRecommendation.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(IdleRecommendation.getter(IdleRecommendation::resourceId)).setter(IdleRecommendation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(IdleRecommendation.getter(IdleRecommendation::resourceTypeAsString)).setter(IdleRecommendation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(IdleRecommendation.getter(IdleRecommendation::accountId)).setter(IdleRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("finding").getter(IdleRecommendation.getter(IdleRecommendation::findingAsString)).setter(IdleRecommendation.setter(Builder::finding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()}).build();
    private static final SdkField<String> FINDING_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingDescription").getter(IdleRecommendation.getter(IdleRecommendation::findingDescription)).setter(IdleRecommendation.setter(Builder::findingDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingDescription").build()}).build();
    private static final SdkField<IdleSavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunity").getter(IdleRecommendation.getter(IdleRecommendation::savingsOpportunity)).setter(IdleRecommendation.setter(Builder::savingsOpportunity)).constructor(IdleSavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build()}).build();
    private static final SdkField<IdleSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunityAfterDiscounts").getter(IdleRecommendation.getter(IdleRecommendation::savingsOpportunityAfterDiscounts)).setter(IdleRecommendation.setter(Builder::savingsOpportunityAfterDiscounts)).constructor(IdleSavingsOpportunityAfterDiscounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts").build()}).build();
    private static final SdkField<List<IdleUtilizationMetric>> UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utilizationMetrics").getter(IdleRecommendation.getter(IdleRecommendation::utilizationMetrics)).setter(IdleRecommendation.setter(Builder::utilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdleUtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> LOOK_BACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("lookBackPeriodInDays").getter(IdleRecommendation.getter(IdleRecommendation::lookBackPeriodInDays)).setter(IdleRecommendation.setter(Builder::lookBackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriodInDays").build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRefreshTimestamp").getter(IdleRecommendation.getter(IdleRecommendation::lastRefreshTimestamp)).setter(IdleRecommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(IdleRecommendation.getter(IdleRecommendation::tags)).setter(IdleRecommendation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, ACCOUNT_ID_FIELD, FINDING_FIELD, FINDING_DESCRIPTION_FIELD, SAVINGS_OPPORTUNITY_FIELD, SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD, UTILIZATION_METRICS_FIELD, LOOK_BACK_PERIOD_IN_DAYS_FIELD, LAST_REFRESH_TIMESTAMP_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdleRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceArn;
    private final String resourceId;
    private final String resourceType;
    private final String accountId;
    private final String finding;
    private final String findingDescription;
    private final IdleSavingsOpportunity savingsOpportunity;
    private final IdleSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;
    private final List<IdleUtilizationMetric> utilizationMetrics;
    private final Double lookBackPeriodInDays;
    private final Instant lastRefreshTimestamp;
    private final List<Tag> tags;

    private IdleRecommendation(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.accountId = builder.accountId;
        this.finding = builder.finding;
        this.findingDescription = builder.findingDescription;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
        this.utilizationMetrics = builder.utilizationMetrics;
        this.lookBackPeriodInDays = builder.lookBackPeriodInDays;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.tags = builder.tags;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final IdleRecommendationResourceType resourceType() {
        return IdleRecommendationResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final IdleFinding finding() {
        return IdleFinding.fromValue(this.finding);
    }

    public final String findingAsString() {
        return this.finding;
    }

    public final String findingDescription() {
        return this.findingDescription;
    }

    public final IdleSavingsOpportunity savingsOpportunity() {
        return this.savingsOpportunity;
    }

    public final IdleSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return this.savingsOpportunityAfterDiscounts;
    }

    public final boolean hasUtilizationMetrics() {
        return this.utilizationMetrics != null && !(this.utilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<IdleUtilizationMetric> utilizationMetrics() {
        return this.utilizationMetrics;
    }

    public final Double lookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    public final Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunityAfterDiscounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationMetrics() ? this.utilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdleRecommendation)) {
            return false;
        }
        IdleRecommendation other = (IdleRecommendation)obj;
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.findingAsString(), other.findingAsString()) && Objects.equals(this.findingDescription(), other.findingDescription()) && Objects.equals(this.savingsOpportunity(), other.savingsOpportunity()) && Objects.equals(this.savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts()) && this.hasUtilizationMetrics() == other.hasUtilizationMetrics() && Objects.equals(this.utilizationMetrics(), other.utilizationMetrics()) && Objects.equals(this.lookBackPeriodInDays(), other.lookBackPeriodInDays()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"IdleRecommendation").add("ResourceArn", (Object)this.resourceArn()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("AccountId", (Object)this.accountId()).add("Finding", (Object)this.findingAsString()).add("FindingDescription", (Object)this.findingDescription()).add("SavingsOpportunity", (Object)this.savingsOpportunity()).add("SavingsOpportunityAfterDiscounts", (Object)this.savingsOpportunityAfterDiscounts()).add("UtilizationMetrics", this.hasUtilizationMetrics() ? this.utilizationMetrics() : null).add("LookBackPeriodInDays", (Object)this.lookBackPeriodInDays()).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "finding": {
                return Optional.ofNullable(clazz.cast(this.findingAsString()));
            }
            case "findingDescription": {
                return Optional.ofNullable(clazz.cast(this.findingDescription()));
            }
            case "savingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunity()));
            }
            case "savingsOpportunityAfterDiscounts": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunityAfterDiscounts()));
            }
            case "utilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.utilizationMetrics()));
            }
            case "lookBackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriodInDays()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("finding", FINDING_FIELD);
        map.put("findingDescription", FINDING_DESCRIPTION_FIELD);
        map.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
        map.put("savingsOpportunityAfterDiscounts", SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD);
        map.put("utilizationMetrics", UTILIZATION_METRICS_FIELD);
        map.put("lookBackPeriodInDays", LOOK_BACK_PERIOD_IN_DAYS_FIELD);
        map.put("lastRefreshTimestamp", LAST_REFRESH_TIMESTAMP_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdleRecommendation, T> g) {
        return obj -> g.apply((IdleRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private String resourceId;
        private String resourceType;
        private String accountId;
        private String finding;
        private String findingDescription;
        private IdleSavingsOpportunity savingsOpportunity;
        private IdleSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;
        private List<IdleUtilizationMetric> utilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double lookBackPeriodInDays;
        private Instant lastRefreshTimestamp;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IdleRecommendation model) {
            this.resourceArn(model.resourceArn);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.accountId(model.accountId);
            this.finding(model.finding);
            this.findingDescription(model.findingDescription);
            this.savingsOpportunity(model.savingsOpportunity);
            this.savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
            this.utilizationMetrics(model.utilizationMetrics);
            this.lookBackPeriodInDays(model.lookBackPeriodInDays);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
            this.tags(model.tags);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IdleRecommendationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getFinding() {
            return this.finding;
        }

        public final void setFinding(String finding) {
            this.finding = finding;
        }

        @Override
        public final Builder finding(String finding) {
            this.finding = finding;
            return this;
        }

        @Override
        public final Builder finding(IdleFinding finding) {
            this.finding(finding == null ? null : finding.toString());
            return this;
        }

        public final String getFindingDescription() {
            return this.findingDescription;
        }

        public final void setFindingDescription(String findingDescription) {
            this.findingDescription = findingDescription;
        }

        @Override
        public final Builder findingDescription(String findingDescription) {
            this.findingDescription = findingDescription;
            return this;
        }

        public final IdleSavingsOpportunity.Builder getSavingsOpportunity() {
            return this.savingsOpportunity != null ? this.savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(IdleSavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(IdleSavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final IdleSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return this.savingsOpportunityAfterDiscounts != null ? this.savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(IdleSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(IdleSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        public final List<IdleUtilizationMetric.Builder> getUtilizationMetrics() {
            List<IdleUtilizationMetric.Builder> result = IdleUtilizationMetricsCopier.copyToBuilder(this.utilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationMetrics(Collection<IdleUtilizationMetric.BuilderImpl> utilizationMetrics) {
            this.utilizationMetrics = IdleUtilizationMetricsCopier.copyFromBuilder(utilizationMetrics);
        }

        @Override
        public final Builder utilizationMetrics(Collection<IdleUtilizationMetric> utilizationMetrics) {
            this.utilizationMetrics = IdleUtilizationMetricsCopier.copy(utilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(IdleUtilizationMetric ... utilizationMetrics) {
            this.utilizationMetrics(Arrays.asList(utilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(Consumer<IdleUtilizationMetric.Builder> ... utilizationMetrics) {
            this.utilizationMetrics(Stream.of(utilizationMetrics).map(c -> (IdleUtilizationMetric)((IdleUtilizationMetric.Builder)IdleUtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getLookBackPeriodInDays() {
            return this.lookBackPeriodInDays;
        }

        public final void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
        }

        @Override
        public final Builder lookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IdleRecommendation build() {
            return new IdleRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdleRecommendation> {
        public Builder resourceArn(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IdleRecommendationResourceType var1);

        public Builder accountId(String var1);

        public Builder finding(String var1);

        public Builder finding(IdleFinding var1);

        public Builder findingDescription(String var1);

        public Builder savingsOpportunity(IdleSavingsOpportunity var1);

        default public Builder savingsOpportunity(Consumer<IdleSavingsOpportunity.Builder> savingsOpportunity) {
            return this.savingsOpportunity((IdleSavingsOpportunity)((IdleSavingsOpportunity.Builder)IdleSavingsOpportunity.builder().applyMutation(savingsOpportunity)).build());
        }

        public Builder savingsOpportunityAfterDiscounts(IdleSavingsOpportunityAfterDiscounts var1);

        default public Builder savingsOpportunityAfterDiscounts(Consumer<IdleSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return this.savingsOpportunityAfterDiscounts((IdleSavingsOpportunityAfterDiscounts)((IdleSavingsOpportunityAfterDiscounts.Builder)IdleSavingsOpportunityAfterDiscounts.builder().applyMutation(savingsOpportunityAfterDiscounts)).build());
        }

        public Builder utilizationMetrics(Collection<IdleUtilizationMetric> var1);

        public Builder utilizationMetrics(IdleUtilizationMetric ... var1);

        public Builder utilizationMetrics(Consumer<IdleUtilizationMetric.Builder> ... var1);

        public Builder lookBackPeriodInDays(Double var1);

        public Builder lastRefreshTimestamp(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

