/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.RDSInstanceEstimatedMonthlySavings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDSInstanceSavingsOpportunityAfterDiscounts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RDSInstanceSavingsOpportunityAfterDiscounts> {
    private static final SdkField<Double> SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("savingsOpportunityPercentage").getter(RDSInstanceSavingsOpportunityAfterDiscounts.getter(RDSInstanceSavingsOpportunityAfterDiscounts::savingsOpportunityPercentage)).setter(RDSInstanceSavingsOpportunityAfterDiscounts.setter(Builder::savingsOpportunityPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityPercentage").build()}).build();
    private static final SdkField<RDSInstanceEstimatedMonthlySavings> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("estimatedMonthlySavings").getter(RDSInstanceSavingsOpportunityAfterDiscounts.getter(RDSInstanceSavingsOpportunityAfterDiscounts::estimatedMonthlySavings)).setter(RDSInstanceSavingsOpportunityAfterDiscounts.setter(Builder::estimatedMonthlySavings)).constructor(RDSInstanceEstimatedMonthlySavings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RDSInstanceSavingsOpportunityAfterDiscounts.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double savingsOpportunityPercentage;
    private final RDSInstanceEstimatedMonthlySavings estimatedMonthlySavings;

    private RDSInstanceSavingsOpportunityAfterDiscounts(BuilderImpl builder) {
        this.savingsOpportunityPercentage = builder.savingsOpportunityPercentage;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
    }

    public final Double savingsOpportunityPercentage() {
        return this.savingsOpportunityPercentage;
    }

    public final RDSInstanceEstimatedMonthlySavings estimatedMonthlySavings() {
        return this.estimatedMonthlySavings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunityPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSInstanceSavingsOpportunityAfterDiscounts)) {
            return false;
        }
        RDSInstanceSavingsOpportunityAfterDiscounts other = (RDSInstanceSavingsOpportunityAfterDiscounts)obj;
        return Objects.equals(this.savingsOpportunityPercentage(), other.savingsOpportunityPercentage()) && Objects.equals(this.estimatedMonthlySavings(), other.estimatedMonthlySavings());
    }

    public final String toString() {
        return ToString.builder((String)"RDSInstanceSavingsOpportunityAfterDiscounts").add("SavingsOpportunityPercentage", (Object)this.savingsOpportunityPercentage()).add("EstimatedMonthlySavings", (Object)this.estimatedMonthlySavings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "savingsOpportunityPercentage": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunityPercentage()));
            }
            case "estimatedMonthlySavings": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("savingsOpportunityPercentage", SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD);
        map.put("estimatedMonthlySavings", ESTIMATED_MONTHLY_SAVINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RDSInstanceSavingsOpportunityAfterDiscounts, T> g) {
        return obj -> g.apply((RDSInstanceSavingsOpportunityAfterDiscounts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double savingsOpportunityPercentage;
        private RDSInstanceEstimatedMonthlySavings estimatedMonthlySavings;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSInstanceSavingsOpportunityAfterDiscounts model) {
            this.savingsOpportunityPercentage(model.savingsOpportunityPercentage);
            this.estimatedMonthlySavings(model.estimatedMonthlySavings);
        }

        public final Double getSavingsOpportunityPercentage() {
            return this.savingsOpportunityPercentage;
        }

        public final void setSavingsOpportunityPercentage(Double savingsOpportunityPercentage) {
            this.savingsOpportunityPercentage = savingsOpportunityPercentage;
        }

        @Override
        public final Builder savingsOpportunityPercentage(Double savingsOpportunityPercentage) {
            this.savingsOpportunityPercentage = savingsOpportunityPercentage;
            return this;
        }

        public final RDSInstanceEstimatedMonthlySavings.Builder getEstimatedMonthlySavings() {
            return this.estimatedMonthlySavings != null ? this.estimatedMonthlySavings.toBuilder() : null;
        }

        public final void setEstimatedMonthlySavings(RDSInstanceEstimatedMonthlySavings.BuilderImpl estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings != null ? estimatedMonthlySavings.build() : null;
        }

        @Override
        public final Builder estimatedMonthlySavings(RDSInstanceEstimatedMonthlySavings estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public RDSInstanceSavingsOpportunityAfterDiscounts build() {
            return new RDSInstanceSavingsOpportunityAfterDiscounts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RDSInstanceSavingsOpportunityAfterDiscounts> {
        public Builder savingsOpportunityPercentage(Double var1);

        public Builder estimatedMonthlySavings(RDSInstanceEstimatedMonthlySavings var1);

        default public Builder estimatedMonthlySavings(Consumer<RDSInstanceEstimatedMonthlySavings.Builder> estimatedMonthlySavings) {
            return this.estimatedMonthlySavings((RDSInstanceEstimatedMonthlySavings)((RDSInstanceEstimatedMonthlySavings.Builder)RDSInstanceEstimatedMonthlySavings.builder().applyMutation(estimatedMonthlySavings)).build());
        }
    }
}

